export type Address = string;
export type VALUE_TYPE = "Value" | "Address" | "Invalid";

export interface IEntry {
  entity: Address,
  attribute: string,
  value: { t: VALUE_TYPE, c: string }
}

export interface ListingResult {
  [key: string]: IEntry
}

export interface Job {
  title: string;
  progress: number;
  state: "InProgress" | "Done" | "Failed",
}

export interface IFile {
  hash: string;
  path: string;
  valid: boolean;
  added: string;
  size: number;
  mtime: string;
}

export interface VaultInfo {
  name: string | null;
  location: string;
}

export type AttributeChange = AttributeCreate | AttributeUpdate | AttributeDelete;

export interface AttributeCreate {
  type: "create",
  attribute: string,
  value: any
}

export interface AttributeUpdate {
  type: "update",
  addr: string,
  value: any
}

export interface AttributeDelete {
  type: "delete",
  addr: string
}