import Inspect from "@/views/Inspect.vue";
import { createRouter, createWebHashHistory, RouteRecordRaw } from 'vue-router';
import Home from "../views/Home.vue";
import Search from '../views/Search.vue';
import File from '../views/File.vue';
import Browse from '../views/Browse.vue';

const routes: Array<RouteRecordRaw> = [
  {
    path: '/',
    name: 'home',
    component: Home
  },
  {
    path: '/search',
    name: 'search',
    component: Search,
  },
  {
    path: "/inspect/:address",
    name: "inspect",
    component: Inspect,
    props: true
  },
  {
    path: "/file/:address",
    name: "file",
    component: File,
    props: true
  },
  {
    path: "/browse/:addresses+",
    name: "browse",
    component: Browse,
    props: true
  },
  {
    path: '/about',
    name: 'about',
    // route level code-splitting
    // this generates a separate chunk (about.[hash].js) for this route
    // which is lazy-loaded when the route is visited.
    component: () => import(/* webpackChunkName: "about" */ '../views/Home.vue')
  }
]

const router = createRouter({
  history: createWebHashHistory(),
  routes
})

export default router
