import { ComponentOptions } from "vue";

export class UpType {
    name: string | null = null;
    attributes: string[] = [];

    public get icon(): string | undefined {
        return this.name ? TYPE_ICONS[this.name] : undefined;
    }

    public get widgetInfo(): ComponentOptions[] | undefined {
        return this.name ? TYPE_WIDGETS[this.name] : undefined;
    }
}

const TYPE_ICONS: { [key: string]: string } = {
    "BLOB": "box",
    "FS_FILE": "file-earmark",
    "FS_DIR": "folder"
}

const TYPE_WIDGETS: { [key: string]: ComponentOptions[] } = {
    "KSX_TRACK_MOODS": [
        {
            name: "Compass",
            id: "compass_tint_energy",
            props: {
                xAttrName: "KSX_TINT",
                yAttrName: "KSX_ENERGY",
                xLabel: "Lightsoft // Heavydark",
                yLabel: "Chill // Extreme",
            }
        },
        {
            name: "Compass",
            id: "compass_seriousness_materials",
            props: {
                xAttrName: "KSX_SERIOUSNESS",
                yAttrName: "KSX_MATERIALS",
                xLabel: "Dionysia // Apollonia",
                yLabel: "Natural // Reinforced",
            }
        }
    ]
}