import { setBasePath, SlInput } from "@shoelace-style/shoelace";
import * as Vue from "vue";
import { DirectiveBinding } from "vue";
import App from "./App.vue";
import router from "./router";

// TODO: Remove when UI settles!
setBasePath(`${window.location.origin}/`);

const app = Vue.createApp(App);
app.use(router);

app.directive("sl-model", {
    beforeMount: (element: Element, binding: DirectiveBinding<string>) => {
        element.addEventListener("sl-input", (event) => {
            const slElement = event?.target as
                | typeof SlInput.prototype
                | undefined;
            const value = slElement?.value;
            if (value && binding.instance) {
                (binding.instance.$data as { [key: string]: unknown })[binding.arg as string] = value;
            }
        });
    },
    updated: (element: Element, binding: DirectiveBinding<string>) => {
        const slElement = element as typeof SlInput.prototype | undefined;
        if (slElement) {
            slElement.value = (binding.instance?.$data as { [key: string]: unknown })[binding.arg as string] as string;
        }
    },
});

app.mount("#app");