import type { UpEntry } from "upend";
import type { InEntry } from "upend/types";
import { putEntry, queryOnce } from "../lib/api";
import { query as queryFn } from "../lib/entity";

export function baseSearch(query: string) {
  return queryFn(
    `(or (matches (contains "${query}") ?  ?) (matches ? (contains "${query}") ?) (matches ? ? (contains "${query}")))`
  );
}

export function baseSearchOnce(query: string) {
  return queryOnce(
    `(or (matches (contains "${query}") ?  ?) (matches ? (contains "${query}") ?) (matches ? ? (contains "${query}")))`
  );
}

export async function getObjects(
  entries: UpEntry[],
  limit = 50
): Promise<[string, string][]> {
  return entries
    .slice(0, limit)
    .filter((e) => e.attribute == "LBL")
    .map((e) => [e.entity, String(e.value.c)] as [string, string]);
}

export async function createLabelled(label: string) {
  let body: InEntry;
  if (label.match("^[\\w]+://[\\w]")) {
    body = {
      entity: {
        t: "Url",
        c: label,
      },
    };
  } else {
    body = {
      attribute: "LBL",
      value: {
        t: "String",
        c: label,
      },
    };
  }

  try {
    const [_, entry] = await putEntry(body);
    return entry;
  } catch (error) {
    throw new Error(`Failed to create object: ${error}`);
  }
}
