export type Address = string;
export type VALUE_TYPE = "Address" | "String" | "Number" | "Invalid";

export interface IEntry {
  entity: Address;
  attribute: string;
  value: IValue;
}

export type IValue =
  | {
      t: "Address";
      c: string;
    }
  | {
      t: "String";
      c: string;
    }
  | {
      t: "Number";
      c: number;
    }
  | {
      t: "Null";
      c: null;
    }
  | {
      t: "Invalid";
      c: null;
    };

export interface InvariantEntry {
  attribute: string;
  value: IValue;
}

export type InAddress =
  | Address
  | { t: "Attribute" | "Url" | "Uuid"; c?: string };

export type InEntry =
  | IEntry
  | IEntry[]
  | InvariantEntry
  | { entity: InAddress };

export interface ListingResult {
  [key: string]: IEntry;
}

// entry address, entity address address
export type PutResult = [string | undefined, string];

// export type OrderedListing = [Address, IEntry][];

export interface IFile {
  hash: string;
  path: string;
  valid: boolean;
  added: string;
  size: number;
  mtime: string;
}

export interface IJob {
  title: string;
  progress: number;
  state: "InProgress" | "Done" | "Failed";
}

export interface VaultInfo {
  name: string | null;
  location: string;
  version: string;
  desktop: boolean;
}
