use crate::{
    addressing::Address,
    database::{entry::Entry, UpEndConnection},
    util::jobs::JobContainer,
};
use anyhow::Result;
use async_trait::async_trait;
use std::sync::{Arc, RwLock};

#[cfg(feature = "extractors-web")]
pub mod web;

#[async_trait]
pub trait Extractor {
    async fn get(
        &self,
        address: Address,
        job_container: Arc<RwLock<JobContainer>>,
    ) -> Result<Vec<Entry>>;

    async fn insert_info(
        &self,
        address: Address,
        connection: UpEndConnection,
        job_container: Arc<RwLock<JobContainer>>,
    ) -> Result<()> {
        let entries = self.get(address, job_container).await?;

        Ok(actix_web::web::block::<_, _, anyhow::Error>(move || {
            connection.transaction(|| {
                for entry in entries {
                    connection.insert_entry(entry)?;
                }
                Ok(())
            })
        })
        .await?)
    }

    async fn insert_info_fnf(
        &self,
        address: Address,
        connection: UpEndConnection,
        job_container: Arc<RwLock<JobContainer>>,
    ) {
        let _ = self.insert_info(address, connection, job_container).await;
    }
}
