use super::Extractor;
use crate::{
    addressing::Address,
    database::{entry::Entry, UpEndConnection},
    util::jobs::{Job, JobContainer, State},
};
use actix_web::web;
use anyhow::{anyhow, Result};
use async_trait::async_trait;
use std::sync::{Arc, Mutex, RwLock};
use webpage::{Webpage, WebpageOptions};

pub struct ID3Extractor;

#[async_trait]
impl Extractor for ID3Extractor {
    async fn get(
        &self,
        address: Address,
        connection: Arc<Mutex<UpEndConnection>>,
        job_container: Arc<RwLock<JobContainer>>,
    ) -> Result<Vec<Entry>> {
        todo!();
    }
}
