table! {
    data (identity) {
        identity -> Binary,
        entity -> Binary,
        entity_searchable -> Nullable<Text>,
        attribute -> Text,
        value_str -> Nullable<Text>,
        value_num -> Nullable<Double>,
        immutable -> Bool,
    }
}

table! {
    files (id) {
        id -> Integer,
        hash -> Binary,
        path -> Text,
        valid -> Bool,
        added -> Timestamp,
        size -> BigInt,
        mtime -> Nullable<Timestamp>,
    }
}

table! {
    meta (id) {
        id -> Integer,
        key -> Text,
        value -> Text,
    }
}

allow_tables_to_appear_in_same_query!(
    data,
    files,
    meta,
);
