use std::path::PathBuf;

use chrono::NaiveDateTime;
use serde::Serialize;

use super::schema::{data, files, meta};
use crate::util::hash::Hash;

#[derive(Queryable, Serialize, Clone, Debug)]
pub struct File {
    pub id: i32,
    pub hash: Hash,
    pub path: String,
    pub valid: bool,
    pub added: NaiveDateTime,
    pub size: i64,
    pub mtime: Option<NaiveDateTime>,
}

// todo - remove, try_from the actual model, impl queryable...
#[derive(Serialize, Clone, Debug)]
pub struct OutFile {
    pub id: i32,
    pub hash: Hash,
    pub path: PathBuf,
    pub valid: bool,
    pub added: NaiveDateTime,
    pub size: i64,
    pub mtime: Option<NaiveDateTime>,
}

#[derive(Insertable, Debug)]
#[table_name = "files"]
pub struct NewFile {
    pub hash: Vec<u8>,
    pub path: String,
    pub added: NaiveDateTime,
    pub size: i64,
    pub mtime: Option<NaiveDateTime>,
}

#[derive(Queryable, Insertable, Serialize, Debug)]
#[table_name = "data"]
pub struct Entry {
    pub identity: Vec<u8>,
    pub entity: Vec<u8>,
    pub entity_searchable: Option<String>,
    pub attribute: String,
    pub value_str: Option<String>,
    pub value_num: Option<f64>,
    pub immutable: bool,
}

#[derive(Queryable, Insertable, Serialize, Clone, Debug)]
#[table_name = "meta"]
pub struct MetaValue {
    pub id: i32,
    pub key: String,
    pub value: String,
}
