export type Address = string;
export type VALUE_TYPE = "Value" | "Address" | "Invalid";

export interface IEntry {
  entity: Address,
  attribute: string,
  value: { t: VALUE_TYPE, c: string }
}

export interface ListingResult {
  [key: string]: IEntry
}

export interface Job {
  title: string;
  progress: number;
}

export interface IFile {
  hash: string;
  path: string;
  valid: boolean;
  added: string;
  size: number;
  mtime: string;
}

export interface VaultInfo {
  name: string | null;
  location: string;
}