import type { IValue } from "upend/types";

export type AttributeChange =
  | AttributeCreate
  | AttributeUpdate
  | AttributeDelete;

export interface AttributeCreate {
  type: "create";
  attribute: string;
  value: IValue;
}

export interface AttributeUpdate {
  type: "update";
  attribute: string;
  value: IValue;
}

export interface AttributeDelete {
  type: "delete";
  address: string;
}
