pub mod hash;
pub mod jobs;

use log::debug;

#[derive(Default)]
pub struct LoggerSink {
    pub buffer: Vec<u8>,
}

impl std::io::Write for LoggerSink {
    fn write(&mut self, buf: &[u8]) -> std::io::Result<usize> {
        self.buffer.extend(buf.iter());

        if self.buffer.ends_with(b"\n") {
            self.flush()?;
        }

        Ok(buf.len())
    }

    fn flush(&mut self) -> std::io::Result<()> {
        use std::str;

        debug!(
            "{}",
            str::from_utf8(self.buffer.as_mut())
                .map_err(|e| std::io::Error::new(std::io::ErrorKind::InvalidData, e))?
                .trim()
        );

        Ok(())
    }
}
