import replace from "@rollup/plugin-replace";
import svelte from "rollup-plugin-svelte";
import commonjs from "@rollup/plugin-commonjs";
import path from "path";
import copy from "rollup-plugin-copy";
import resolve from "@rollup/plugin-node-resolve";
import livereload from "rollup-plugin-livereload";
import { terser } from "rollup-plugin-terser";
import sveltePreprocess from "svelte-preprocess";
import typescript from "@rollup/plugin-typescript";
import css from "rollup-plugin-css-only";
import dev from "rollup-plugin-dev";

const production = !process.env.ROLLUP_WATCH;

export default {
  input: "src/main.ts",
  output: {
    sourcemap: true,
    format: "esm",
    name: "app",
    dir: "public/build",
  },
  plugins: [
    // To fix `history`
    replace({
      "process.env.NODE_ENV": JSON.stringify("production"),
    }),
    svelte({
      preprocess: sveltePreprocess({
        sourceMap: !production,
      }),
      compilerOptions: {
        // enable run-time checks when not in production
        dev: !production,
      },
      exclude: [path.resolve(__dirname, "public/vendor")],
    }),
    // we'll extract any component CSS out into
    // a separate file - better for performance
    css({ output: "bundle.css" }),

    // If you have external dependencies installed from
    // npm, you'll most likely need these plugins. In
    // some cases you'll need additional configuration -
    // consult the documentation for details:
    // https://github.com/rollup/plugins/tree/master/packages/commonjs
    resolve({
      browser: true,
      dedupe: ["svelte"],
    }),
    commonjs(),
    typescript({
      sourceMap: !production,
      inlineSources: !production,
    }),

    copy({
      copyOnce: true,
      hook: "closeBundle",
      verbose: true,
      targets: [
        {
          src: path.join(
            path.dirname(require.resolve("boxicons/package.json")),
            "fonts"
          ),
          dest: path.resolve(__dirname, "public/vendor/boxicons"),
        },
        {
          src: path.join(
            path.dirname(require.resolve("boxicons/package.json")),
            "css"
          ),
          dest: path.resolve(__dirname, "public/vendor/boxicons"),
        },
      ],
    }),

    !production &&
      dev({
        dirs: ["public"],
        proxy: [
          {
            from: "/api/",
            to: "http://localhost:8093/api/",
          },
        ],
      }),

    // Watch the `public` directory and refresh the
    // browser on changes when not in production
    !production && livereload("public"),

    // If we're building for production (npm run build
    // instead of npm run dev), minify
    production && terser(),
  ],
  watch: {
    clearScreen: false,
  },
};
