use crate::addressing::Address;
use crate::database::entry::{EntryValue, InvariantEntry};

pub const TYPE_TYPE_VAL: &str = "TYPE";
pub const TYPE_BASE_ATTR: &str = "TYPE";
pub const TYPE_HAS_ATTR: &str = "TYPE_HAS";
// pub const TYPE_ATTR_REQUIRED: &str = "TYPE_ATTR_REQUIRED";

pub const IS_OF_TYPE_ATTR: &str = "IS";

pub const HIER_TYPE_VAL: &str = "HIER";
pub const HIER_HAS_ATTR: &str = "HAS";

pub const LABEL_ATTR: &str = "LBL";

lazy_static! {
    pub static ref TYPE_INVARIANT: InvariantEntry = InvariantEntry {
        attribute: String::from(TYPE_BASE_ATTR),
        value: EntryValue::String(String::from(TYPE_TYPE_VAL)),
    };
    pub static ref TYPE_ADDR: Address = TYPE_INVARIANT.entity().unwrap();
    pub static ref HIER_INVARIANT: InvariantEntry = InvariantEntry {
        attribute: String::from(TYPE_BASE_ATTR),
        value: EntryValue::String(String::from(HIER_TYPE_VAL)),
    };
    pub static ref HIER_ADDR: Address = HIER_INVARIANT.entity().unwrap();
}
