const path = require("path");
const CopyPlugin = require("copy-webpack-plugin");

module.exports = {
  lintOnSave: false,
  chainWebpack: config => {
    config.module
      .rule('vue')
      .use('vue-loader')
      .tap(options => {
        const compilerOptions = {
        }
        compilerOptions.isCustomElement = (tag) => tag.startsWith('sl-');
        options.compilerOptions = compilerOptions;
        return options
      });
    config.plugin("copy-icons").use(CopyPlugin, [
      [
        {
          from: path.resolve(
            __dirname,
            "node_modules/@shoelace-style/shoelace/dist/assets/icons"
          ),
          to: path.resolve(__dirname, "dist/assets/icons")
        }
      ]
    ]);
    config.devServer.proxy({
      "/api": { target: "http://localhost:8093" }
    });
  }
};
