use anyhow::{anyhow, Result};

include!(concat!(env!("OUT_DIR"), "/built.rs"));

pub fn get_static_dir<S: AsRef<str>>(dir: S) -> Result<std::path::PathBuf> {
    let cwd = std::env::current_exe()?.parent().unwrap().to_path_buf();
    let base_path = if PROFILE == "debug" {
        cwd.join("../../tmp/static")
    } else {
        cwd
    };
    let result = base_path.join(dir.as_ref());
    if result.exists() {
        Ok(result)
    } else {
        Err(anyhow!("Path {result:?} doesn't exist."))
    }
}
