import type { UpEntry } from "upend";
import type { ListingResult } from "upend/types";
import { fetchEntry, query as queryFn, queryOnce } from "../lib/entity";

export function baseSearch(query: string) {
  return queryFn(() => `(matches ? ? (contains "${query}"))`);
}

export function baseSearchOnce(query: string) {
  return queryOnce(`(matches ? ? (contains "${query}"))`);
}

export async function getObjects(
  entries: UpEntry[]
): Promise<[string, string][]> {
  const labelled = entries
    .filter((e) => e.attribute == "LBL")
    .map((e) => [e.entity, String(e.value.c)] as [string, string]);
  const aliased = entries
    .filter((e) => e.attribute === "ALIAS")
    .map(async (aliasEntry) => {
      const entry = await fetchEntry(aliasEntry.entity);
      return [String(entry.value.c), String(aliasEntry.value.c)] as [
        string,
        string
      ];
    });
  return labelled.concat(await Promise.all(aliased));
}

export async function createLabelled(label: string) {
  const response = await fetch(`/api/obj`, {
    method: "PUT",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({
      attribute: "LBL",
      value: {
        t: "String",
        c: label,
      },
    }),
  });
  if (!response.ok) {
    throw new Error(`Failed to create object: ${await response.text()}`);
  }
  const result = (await response.json()) as ListingResult;
  const address = Object.values(result)[0].entity;
  return address;
}
