export type Address = string;
export type VALUE_TYPE = "Address" | "String" | "Number" | "Invalid";

export interface IEntry {
  entity: Address;
  attribute: string;
  value: IValue;
}

const model: { [key in VALUE_TYPE as string]: unknown } = {
  String: "string",
  Address: "address",
  Number: 123,
  Invalid: null,
};

export type IValue =
  | {
      t: "Address";
      c: string;
    }
  | {
      t: "String";
      c: string;
    }
  | {
      t: "Number";
      c: number;
    }
  | {
      t: "Invalid";
      c: null;
    };

export interface ListingResult {
  [key: string]: IEntry;
}

// export type OrderedListing = [Address, IEntry][];

export interface IFile {
  hash: string;
  path: string;
  valid: boolean;
  added: string;
  size: number;
  mtime: string;
}

export interface IJob {
  title: string;
  progress: number;
  state: "InProgress" | "Done" | "Failed";
}

export interface VaultInfo {
  name: string | null;
  location: string;
}
