import { writable } from "svelte/store";

// stale shim until https://github.com/ConsoleTVs/sswr/issues/24 is resolved
export type SWRKey = string;
export function useSWR<D = unknown, E = Error>(
  key: SWRKey | undefined | (() => SWRKey | undefined)
) {
  const data = writable<D | undefined>();
  const error = writable<E | undefined>();

  async function doFetch() {
    let keyString = typeof key === "string" ? key : key();
    try {
      const response = await fetch(keyString);
      if (response.ok) {
        data.set(await response.json());
      } else {
        throw new Error(await response.json());
      }
    } catch (err) {
      error.set(err);
    }
  }

  doFetch();

  return {
    data,
    error,
    revalidate: doFetch,
  };
}
