import mitt from "mitt";

type NotifyEvents = {
  notification: UpNotification;
};

export type UpNotificationLevel = "info" | "warning" | "error";

export interface INotification {
  id: string;
  content: string;
  level: UpNotificationLevel;
}

export class UpNotification implements INotification {
  id: string;
  content: string;
  level: UpNotificationLevel;

  constructor(content: string, level?: UpNotificationLevel) {
    this.id = String(Math.random());
    this.content = content;
    this.level = level || "info";
  }
}

export const notify = mitt<NotifyEvents>();
