#[cfg(feature = "previews-image")]
use image::{io::Reader as ImageReader, GenericImageView};
use std::{cmp, path::Path};

use anyhow::Result;

use super::Previewable;

pub struct ImagePath<'a>(pub &'a Path);

impl<'a> Previewable for ImagePath<'a> {
    fn get_thumbnail(&self) -> Result<Option<Vec<u8>>> {
        #[cfg(feature = "previews-image")]
        {
            let image = ImageReader::open(&self.0)?.decode()?;
            let (w, h) = image.dimensions();
            if cmp::max(w, h) > 1024 {
                let thumbnail = image.thumbnail(1024, 1024);
                let thumbnail = thumbnail.into_rgba8();
                let (w, h) = thumbnail.dimensions();
                let encoder = webp::Encoder::from_rgba(&thumbnail, w, h);
                let result = encoder.encode(90.0);
                Ok(Some(result.to_vec()))
            } else {
                Ok(None)
            }
        }

        #[cfg(not(feature = "previews-image"))]
        Err(anyhow!("Image preview support not enabled!"))
    }
}
