table! {
    data (identity) {
        identity -> Binary,
        entity -> Binary,
        attribute -> Text,
        value -> Text,
        immutable -> Bool,
    }
}

table! {
    files (id) {
        id -> Integer,
        hash -> Binary,
        path -> Text,
        valid -> Bool,
        added -> Timestamp,
        size -> BigInt,
        mtime -> Nullable<Timestamp>,
    }
}

table! {
    meta (id) {
        id -> Nullable<Integer>,
        key -> Text,
        value -> Text,
    }
}

allow_tables_to_appear_in_same_query!(
    data,
    files,
    meta,
);
