macro_rules! upend_insert_val {
    ($db_connection:expr, $entity:expr, $attribute:expr, $value:expr) => {{
        $db_connection.insert_entry(
            Entry {
                entity: $entity.clone(),
                attribute: String::from($attribute),
                value: crate::database::entry::EntryValue::Value(serde_json::Value::from($value)),
            },
        )
    }};
}

macro_rules! upend_insert_addr {
    ($db_connection:expr, $entity:expr, $attribute:expr, $addr:expr) => {{
        $db_connection.insert_entry(
            Entry {
                entity: $entity.clone(),
                attribute: String::from($attribute),
                value: crate::database::entry::EntryValue::Address($addr.clone()),
            },
        )
    }};
}
