use anyhow::Result;
use std::{cmp::min, convert::TryInto, fs::File, io::Read, path::Path};

use super::Previewable;

pub struct TextPath<'a>(pub &'a Path);

impl<'a> Previewable for TextPath<'a> {
    fn get_thumbnail(&self) -> Result<Vec<u8>> {
        let mut f = File::open(self.0)?;
        let mut buffer = vec![0u8; min(1024, f.metadata()?.len().try_into()?)];
        f.read_exact(&mut buffer)?;
        Ok(buffer)
    }
}
