import Table from "../components/widgets/Table.svelte";

export class UpType {
  address: string;
  name: string | null = null;
  attributes: string[] = [];

  constructor(address?: string) {
    this.address = address;
  }

  public get icon(): string | undefined {
    return this.name ? TYPE_ICONS[this.name] : undefined;
  }

  public get widgetInfo(): Widget | undefined {
    return this.name ? TYPE_WIDGETS[this.name] : undefined;
  }
}

export const UNTYPED = new UpType("UNTYPED");

export interface Component {
  component: any; // TODO
  props?: { [key: string]: unknown };
}

export interface Widget {
  name: string;
  icon?: string;
  components: Array<Component>;
}

const TYPE_ICONS: { [key: string]: string } = {
  BLOB: "box",
  HIER: "folder",
};

const TYPE_WIDGETS: { [key: string]: Widget } = {
  HIER: {
    name: "hierarchical-listing",
    icon: "folder",
    components: [
      {
        component: Table,
        props: {
          columns: "value",
        },
      },
    ],
  },
  KSX_TRACK_MOODS: {
    name: "ksx-track-compass",
    icon: "plus-square",
    components: [
      // {
      //   name: "Compass",
      //   id: "compass_tint_energy",
      //   props: {
      //     xAttrName: "KSX_TINT",
      //     yAttrName: "KSX_ENERGY",
      //     xLabel: "Lightsoft // Heavydark",
      //     yLabel: "Chill // Extreme",
      //   },
      // },
      // {
      //   name: "Compass",
      //   id: "compass_seriousness_materials",
      //   props: {
      //     xAttrName: "KSX_SERIOUSNESS",
      //     yAttrName: "KSX_MATERIALS",
      //     xLabel: "Dionysia // Apollonia",
      //     yLabel: "Natural // Reinforced",
      //   },
      // },
    ],
  },
};
