export type Address = string;
export type VALUE_TYPE = "Value" | "Address" | "Invalid";

export interface IEntry {
  entity: Address;
  attribute: string;
  value: { t: VALUE_TYPE; c: string | number };
}

export interface ListingResult {
  [key: string]: IEntry;
}

// export type OrderedListing = [Address, IEntry][];

export interface Job {
  title: string;
  progress: number;
  state: "InProgress" | "Done" | "Failed";
}

export interface IFile {
  hash: string;
  path: string;
  valid: boolean;
  added: string;
  size: number;
  mtime: string;
}

export interface VaultInfo {
  name: string | null;
  location: string;
}