use chrono::NaiveDateTime;
use serde::Serialize;

use super::schema::{data, files};
use crate::util::hash::Hash;

#[derive(Queryable, Serialize, Clone, Debug)]
pub struct File {
    pub id: i32,
    pub hash: Hash,
    pub path: String,
    pub valid: bool,
    pub added: NaiveDateTime,
    pub size: i64,
    pub mtime: Option<NaiveDateTime>,
}

#[derive(Insertable, Debug)]
#[table_name = "files"]
pub struct NewFile {
    pub hash: Vec<u8>,
    pub path: String,
    pub added: NaiveDateTime,
    pub size: i64,
    pub mtime: Option<NaiveDateTime>,
}

#[derive(Queryable, Insertable, Serialize, Debug)]
#[table_name = "data"]
pub struct Entry {
    pub identity: Vec<u8>,
    pub entity: Vec<u8>,
    pub attribute: String,
    pub value: String,
}
