import type { Address, IEntry, ListingResult, OrderedListing } from "./types";

export function listingAsOrdered(listing: ListingResult): OrderedListing {
  const entries = Object.entries(listing) as [Address, IEntry][];
  return entries
    .sort(([_, a], [__, b]) => String(a.value.c).localeCompare(b.value.c))
    .sort(([_, a], [__, b]) => String(a.value.t).localeCompare(b.value.t))
    .sort(([_, a], [__, b]) => a.attribute.localeCompare(b.attribute));
}

export function asDict(attributes: OrderedListing): {
  [key: string]: string;
} {
  const result = {} as { [key: string]: string };
  attributes
    .map(([_, attribute]) => attribute)
    .forEach((attribute) => {
      result[attribute.attribute] = attribute.value.c;
    });
  return result;
}
