use color_eyre::eyre::Result;

use crate::{
    config,
    tasks::{self, TasksAction, TasksDir},
};

pub mod git;

/// Comment to add to top of files generated by this program.
const GENERATED_PRELUDE_COMMENT: &str = "# This file was auto-generated by up-rs.\n";

pub fn run(config: &config::UpConfig) -> Result<()> {
    tasks::run(config, TasksDir::GenerateTasks, TasksAction::Run)
}
