#[cfg(feature = "tokio")]
extern crate runtime_tokio as tokio;
#[cfg(feature = "async-std")]
extern crate runtime_async_std as async_std;

use std::fs::File;
use std::io::prelude::*;

use futures::stream::StreamExt;

use tempdir::TempDir;

#[cfg(feature = "tokio")]
#[tokio::test]
async fn version_list_tokio() {
	let mut entries = unrar_async::Archive::new("data/version.rar".into()).unwrap().list().await.unwrap();
	let entry = entries.next().await;
	let entry = entry.unwrap();
	assert_eq!(entry.unwrap().filename, "VERSION");
}

#[cfg(feature = "async-std")]
#[async_std::test]
async fn version_list_async_std() {
	let mut entries = unrar_async::Archive::new("data/version.rar".into()).unwrap().list().await.unwrap();
	let entry = entries.next().await;
	let entry = entry.unwrap();
	assert_eq!(entry.unwrap().filename, "VERSION");
}

#[cfg(feature = "tokio")]
#[tokio::test]
async fn version_cat_tokio() {
	let t = TempDir::new("unrar").unwrap();
	unrar_async::Archive::new("data/version.rar".into())
		.unwrap()
		.extract_to(t.path())
		.await
		.unwrap()
		.process()
		.await
		.unwrap();
	let mut file = File::open(t.path().join("VERSION")).unwrap();
	let mut s = String::new();
	file.read_to_string(&mut s).unwrap();
	assert_eq!(s, "unrar-0.4.0");
}

#[cfg(feature = "async-std")]
#[async_std::test]
async fn version_cat_async_std() {
	let t = TempDir::new("unrar").unwrap();
	unrar_async::Archive::new("data/version.rar".into())
		.unwrap()
		.extract_to(t.path())
		.await
		.unwrap()
		.process()
		.await
		.unwrap();
	let mut file = File::open(t.path().join("VERSION")).unwrap();
	let mut s = String::new();
	file.read_to_string(&mut s).unwrap();
	assert_eq!(s, "unrar-0.4.0");
}

