#[cfg(feature = "tokio")]
extern crate runtime_tokio as tokio;
#[cfg(feature = "async-std")]
extern crate runtime_async_std as async_std;

use futures::stream::StreamExt;

use unrar_async::Archive;
use unrar_async::Error;
use unrar_async::error::RarError;

#[cfg(feature = "tokio")]
#[tokio::test]
async fn list_missing_volume_tokio() {
	let expected = vec![
		"build.rs",
		"Cargo.toml",
		"examples/lister.rs",
		"src/lib.rs",
		"vendor/unrar/acknow.txt",
		"vendor/unrar/arccmt.cpp"
	];
	let mut archive = Archive::new("data/archive.part1.rar".into()).unwrap().list().await.unwrap();
	let mut stream = archive.by_ref().enumerate().take(expected.len());
	while let Some((i, entry)) = stream.next().await {
		let entry = entry.unwrap();
		assert_eq!(entry.filename, expected[i]);
	}
	let err = archive.next().await.unwrap().err().unwrap();
	assert!(matches!(err, Error::Rar(RarError::OpenVolume))); 
}

#[cfg(feature = "async-std")]
#[async_std::test]
async fn list_missing_volume_async_std() {
	let expected = vec![
		"build.rs",
		"Cargo.toml",
		"examples/lister.rs",
		"src/lib.rs",
		"vendor/unrar/acknow.txt",
		"vendor/unrar/arccmt.cpp"
	];
	let mut archive = Archive::new("data/archive.part1.rar".into()).unwrap().list().await.unwrap();
	let mut stream = archive.by_ref().enumerate().take(expected.len());
	while let Some((i, entry)) = stream.next().await {
		let entry = entry.unwrap();
		assert_eq!(entry.filename, expected[i]);
	}
	let err = archive.next().await.unwrap().err().unwrap();
	assert!(matches!(err, Error::Rar(RarError::OpenVolume))); 
}

