/// The actions that can be taken on an archive
#[derive(Clone, Copy, Debug, Eq, PartialEq)]
#[repr(u8)]
pub enum OpenMode {
	List = unrar_sys::RAR_OM_LIST as u8,
	Extract = unrar_sys::RAR_OM_EXTRACT as u8,
	ListSplit = unrar_sys::RAR_OM_LIST_INCSPLIT as u8
}

/// The operations that can be performed on an archive's contents
#[derive(Clone, Copy, Debug, Eq, PartialEq)]
#[repr(u8)]
pub enum Operation {
	Skip = unrar_sys::RAR_SKIP as u8,
	Test = unrar_sys::RAR_TEST as u8,
	Extract = unrar_sys::RAR_EXTRACT as u8
}

bitflags::bitflags! {
	/// Flags representing the properties of an archive
	#[derive(Default)]
	pub struct ArchiveFlags: u16 {
		const VOLUME = unrar_sys::ROADF_VOLUME as u16;
		const COMMENT = unrar_sys::ROADF_COMMENT as u16;
		const LOCK = unrar_sys::ROADF_LOCK as u16;
		const SOLID = unrar_sys::ROADF_SOLID as u16;
		const NEW_NUMBERING = unrar_sys::ROADF_NEWNUMBERING as u16;
		const SIGNED = unrar_sys::ROADF_SIGNED as u16;
		const RECOVERY = unrar_sys::ROADF_RECOVERY as u16;
		const ENC_HEADERS = unrar_sys::ROADF_ENCHEADERS as u16;
		const FIRST_VOLUME = unrar_sys::ROADF_FIRSTVOLUME as u16;
	}
}

/// Types of volumes that comprise a multi-part archive
#[derive(Clone, Copy, Debug, Eq, PartialEq)]
pub enum VolumeInfo {
	None,
	First,
	Subsequent
}

