//! # 子协议层
//!
//! 子协议层(protocol)规定了子协议接口(Protocol)

use crate::consts::*;
use crate::net;
use crate::Connection;
use fixed_queue::LinearMap;
use futures_intrusive::buffer::ArrayBuf;
use futures_intrusive::channel::shared::*;
use log::warn;
use spin::Mutex;
type BTreeMap<K, V> = LinearMap<K, V, PROTOCOL_LEN>;

static CH_LIST: Mutex<BTreeMap<u8, WaitDataSender>> = Mutex::new(BTreeMap::new());

pub struct Respose {
    pub data: VecData,
    pub conn: Connection,
}
type RingBody = ArrayBuf<Respose, [Respose; 1]>;
type WaitDataSender = GenericSender<Mutex<()>, Respose, RingBody>;
type WaitDataRecver = GenericReceiver<Mutex<()>, Respose, RingBody>;
pub type WaitDataFuture = ChannelReceiveFuture<Mutex<()>, Respose>;

pub struct Protocol {
    id: u8,
    recver: WaitDataRecver,
}
impl Protocol {
    /// 创建子协议
    pub fn new(id: u8) -> Result<Protocol, &'static str> {
        let mut ch_list = CH_LIST.lock();
        if let Some(_) = ch_list.get(&id) {
            return Err("repeat.");
        }
        let (sender, recver) = generic_channel(1);
        if ch_list.len() >= PROTOCOL_LEN {
            return Err("full.");
        }
        ch_list.insert(id, sender);

        Ok(Protocol {
            id: id,
            recver: recver,
        })
    }
    pub fn recv(&self) -> WaitDataFuture {
        self.recver.receive()
    }
    pub async fn send(&self, data: &[u8], conn: &Connection) -> Result<(), ()> {
        net::send(self.id, data, conn).await
    }
}

/// 分发数据
pub(crate) fn distribute(id: u8, conn: Connection, data: &[u8]) {
    if let Some(sender) = CH_LIST.lock().get(&id) {
        let rep = Respose {
            data: VecData::from(data),
            conn: conn,
        };
        task_stream::spawn(sender.send(rep));
    } else {
        warn!("unmp_protocol {} is not exist.", id);
    };
}
