//! 历史记录

use crate::consts::HISTORY_LEN;
use crate::net::packet::Packet;
use core::num::Wrapping;
use fixed_queue::History as FixedHistory;

/// 记录
#[derive(PartialEq)]
struct Log {
    id: u16,
    sn: u8,
    data_sum: Wrapping<u8>,
}
impl Log {
    fn new(packet: &Packet) -> Log {
        let head = packet.head();
        let data = packet.data();
        Log {
            id: crc16::State::<crc16::MODBUS>::calculate(&head.src())
                ^ crc16::State::<crc16::MODBUS>::calculate(&head.dst()),
            sn: head.sn(),
            data_sum: data.iter().map(|n| Wrapping(*n)).sum(),
        }
    }
}

pub struct History {
    inner: FixedHistory<Log, HISTORY_LEN>,
}
impl History {
    pub const fn new() -> History {
        History {
            inner: FixedHistory::new(),
        }
    }
    /// 添加记录
    pub fn add(&self, packet: &Packet) -> bool {
        let new_log = Log::new(packet);
        self.inner.insert(new_log)
    }
}
