use crate::id::Id;
use unmp_link::Link;

#[derive(Clone)]
pub struct Connection {
    id: Id,
    link: Option<Link>,
}
impl Connection {
    pub const fn new(id: Id) -> Self {
        Connection { id: id, link: None }
    }
    pub fn id(&self) -> &Id {
        &self.id
    }
    pub fn link(&self) -> Option<&Link> {
        self.link.as_ref()
    }
    pub fn set_link(&mut self, link: Link) {
        self.link = Some(link)
    }
    pub fn clear_link(&mut self) {
        self.link = None
    }
}
