//! 常量表
use fixed_queue::Vec;

/// 数据包长度
pub const PACKET_LEN: usize = 240;
/// 数据包
pub type VecPacket = Vec<u8, PACKET_LEN>;
/// 数据长度
pub const DATA_LEN: usize = 180;
/// 数据
pub type VecData = Vec<u8, DATA_LEN>;

cfg_if::cfg_if! {
    if #[cfg(feature = "role_center")] {
        #[path = "role_center.rs"]
        mod role;
    } else if #[cfg(feature = "role_router")] {
        #[path = "role_router.rs"]
        mod role;
    } else {
        #[path = "role_client.rs"]
        mod role;
    }
}

pub use role::*;
