//! 透传协议

#![no_std]

use log::warn;
use spin::Once;
use unmp::protocol::Protocol;
pub use unmp::protocol::{Respose, WaitDataFuture};
use unmp::Connection;

/// 协议ID
pub const PROTOCOL_ID: u8 = 0;

static RAW: Once<Protocol> = Once::new();

/// 初始化
pub fn init() {
    if let Ok(protocol) = Protocol::new(PROTOCOL_ID) {
        RAW.call_once(|| protocol);
    } else {
        warn!("can't crate raw.")
    }
}
/// 发送数据到指定设备
pub async fn send(buf: &[u8], conn: &Connection) -> Result<(), ()> {
    let raw = RAW.get().unwrap();
    return raw.send(&buf, conn).await;
}
/// 接收数据
pub fn recv() -> WaitDataFuture {
    let raw = RAW.get().unwrap();
    return raw.recv();
}
