//! 历史记录

use crate::consts::HISTORY_LEN;
use crate::datagram::Datagram;
use core::num::Wrapping;
use fixed_queue::History as FixedHistory;

/// 记录
#[derive(PartialEq)]
struct Log {
    sn: u16,
    body: Wrapping<u8>,
}
impl Log {
    fn new(datagram: &Datagram) -> Log {
        let head = datagram.head();
        let body = datagram.body();
        Log {
            sn: head.index(),
            body: body.iter().map(|n| Wrapping(*n)).sum(),
        }
    }
}

pub struct History {
    inner: FixedHistory<Log, HISTORY_LEN>,
}
impl History {
    pub const fn new() -> History {
        History {
            inner: FixedHistory::new(),
        }
    }
    /// 添加记录
    pub fn add(&self, datagram: &Datagram) -> bool {
        let new_log = Log::new(datagram);
        self.inner.insert(new_log)
    }
}
