//! 常量表
use fixed_queue::Vec;
use unmp::consts::{VecData, DATA_LEN};

/// 协议ID
pub const PROTOCOL_ID: u8 = 1;

/// 版本号
pub const VERSION: u8 = 1;
/// 数据报最小长度(消息体长度为0)
pub const MIN_LEN: usize = 6;
/// 数据报最大长度
pub const MAX_LEN: usize = DATA_LEN;
/// 消息体最大长度
pub const BODY_MAX_LEN: usize = MAX_LEN - MIN_LEN;
pub type VecDatagram = VecData;
pub type VecBody = Vec<u8, BODY_MAX_LEN>;

cfg_if::cfg_if! {
    if #[cfg(feature = "role_center")] {
        #[path = "role_center.rs"]
        mod role;
    } else if #[cfg(feature = "role_router")] {
        #[path = "role_router.rs"]
        mod role;
    } else {
        #[path = "role_client.rs"]
        mod role;
    }
}

pub use role::*;
