use unmp::id::Id;
use unmp::link::Link;
use unmp::Connection;

/// etp地址
#[derive(Clone)]
pub struct Addr {
    /// 设备ID
    pub(crate) conn: Connection,
    /// 端口号
    pub(crate) port: u8,
}
impl Addr {
    pub const fn new(conn: Connection, port: u8) -> Self {
        Self {
            conn: conn,
            port: port,
        }
    }
    pub fn conn(&self) -> &Connection {
        &self.conn
    }
    pub fn id(&self) -> &Id {
        self.conn.id()
    }
    pub fn link(&self) -> Option<&Link> {
        self.conn.link()
    }
    pub fn port(&self) -> u8 {
        self.port
    }
}
