//! 内测ID

use crate::{Id, IdKind, ID_LEN};
#[cfg(feature = "wasm")]
use wasm_bindgen::prelude::*;

#[cfg_attr(feature = "wasm", wasm_bindgen)]
#[derive(Debug, PartialEq)]
pub struct SpecialId {
    sn: [u8; 2],
}
#[cfg_attr(feature = "wasm", wasm_bindgen)]
impl SpecialId {
    pub const fn new(sn: [u8; 2]) -> Self {
        return SpecialId { sn };
    }
    pub const fn id(&self) -> Id {
        let mut buf: [u8; ID_LEN] = [0; ID_LEN];
        buf[0] = 0x60 | 1;
        buf[1] = self.sn[0];
        buf[2] = self.sn[1];
        Id {
            len: 1 + 2,
            buf: buf,
        }
    }
    pub fn try_from(id: &Id) -> Option<SpecialId> {
        if id.kind() != IdKind::Special {
            return None;
        }
        if id.len() as u8 != 3 {
            return None;
        }
        let sn = [id.buf[1], id.buf[2]];
        return Some(SpecialId { sn });
    }
}
