#![doc = include_str!("../README.md")]
use proc_macro::TokenStream;
use syn::parse_macro_input;
use quote::quote;
use const_frac::frac::syn::ClonedPath;

mod unit;

use unit:: { TokenUnit, TokenDim };

#[proc_macro]
pub fn unit(input: TokenStream) -> TokenStream {
    let result = parse_macro_input!(input as TokenUnit);

    quote! { #result }.into()
}

#[proc_macro]
pub fn dim(input: TokenStream) -> TokenStream {
    let result = parse_macro_input!(input as TokenDim<ClonedPath>);

    quote! { #result }.into()
}