# RustUnits

[![Build](https://github.com/putridparrot/RustUnits/actions/workflows/build.yml/badge.svg)](https://github.com/putridparrot/RustUnits/actions/workflows/build.yml)
[![GitHub license](https://img.shields.io/badge/license-MIT-blue.svg)](https://github.com/putridparrot/PutridParrot.Units/blob/master/LICENSE.md)
[![GitHub Releases](https://img.shields.io/github/release/putridparrot/RustUnits.svg)](https://github.com/putridparrot/RustUnits/releases)
[![GitHub Issues](https://img.shields.io/github/issues/putridparrot/RustUnits.svg)](https://github.com/putridparrot/RustUnits/issues)

# WiP, still learning to deploy package etc.

The main aim for this project is to produce conversion functions for the various units of measurement (listed below). The code and the unit tests are auto-generated by the UnitCodeGenerator tool. Hence any changes need to made within the definitions file.

Package available via [crates.io](https://crates.io/crates/unit-conversions)

### Unit conversions also available for 

[C#](https://github.com/putridparrot/PutridParrot.Units)  
[F#](https://github.com/putridparrot/FSharp.Units)  
[Java](https://github.com/putridparrot/JavaUnits)  
[Python](https://github.com/putridparrot/PyUnits)  
[Swift](https://github.com/putridparrot/SwiftUnits)  
[TypeScript](https://github.com/putridparrot/unit-conversions)   

### Example

Example of usage:

```
use unit_conversions::*;

fn main() {
    let radians: f64 = angle::degrees::to_radians(800.0);
    println!("{}", radians);
}
```

Each unit of measure then includes functions to convert to each for example, converting each Temperature unit of measure to each other Temperature.

### Angle

	* Degrees (deg)
	* Gradians (grad)
	* Milliradians (mrad)
	* Minute Of Arc (arcmin)
	* Radians (rad)
	* Seconds Of Arc (arcseconds)

### Area

	* Acres (acre)
	* Hectares (hectare)
	* Square Feet (feet2)
	* Square Inches (inch2)
	* Square Kilometres (km2)
	* Square Metres (m2)
	* Square Miles (mile2)
	* Square Yards (yard2)

### Data Storage

	* Bits (b)
	* Gigabits (Gb)
	* Gigabytes (GB)
	* Kibibits (kibibit)
	* Kilobits (k)
	* Kilobytes (KB)
	* Mebibits (mebibit)
	* Megabits (Mb)
	* Megabytes (MB)
	* Terabits (Tb)
	* Terabytes (TB)

### Data Transfer Rate

	* Bits Per Second (bps)
	* GigaBits Per Second (Gbps)
	* GigaBytes Per Second (GBps)
	* Kibibits Per Second (Kibitps)
	* KiloBits Per Second (kbps)
	* KiloBytes Per Second (kBps)
	* Mebibits Per Second (Mibit)
	* MegaBits Per Second (Mbps)
	* MegaBytes Per Second (MBps)
	* TeraBits Per Second (Tbps)
	* TeraBytes Per Second (TBps)

### Energy

	* Btu (btu)
	* Calories (cal)
	* Electronvolts (eV)
	* Foot Pounds (ftlb)
	* Joules (J)
	* Kilocalories (kCal)
	* Kilojoules (kJ)
	* Kilowatt Hours (kWh)
	* US Therms (ustherm)
	* Watt Hours (Wh)

### Force

	* Dynes (dyn)
	* Kilogram-force (kp)
	* Newtons (N)
	* Poundals (pdl)

### Frequency

	* Gigahertz (GHz)
	* Hertz (Hz)
	* Kilohertz (kHz)
	* Megahertz (MHz)

### Fuel Economy

	* Kilometre Per Litre (kml)
	* Litres Per 100 Kilometres (l100km)
	* Miles Per Gallon (mpg)
	* US Miles Per Gallon (usmpg)

### Length

	* Centimetres (cm)
	* Feet (ft)
	* Inches (inch)
	* Kilometres (km)
	* Metres (m)
	* Miles (mile)
	* Millimetres (mm)
	* Nautical Miles (NM)
	* Yards (yard)

### Luminous Energy

	* LumenHour (lmh)
	* LumenMinute (lmmin)
	* LumenSecond (lms)
	* Talbot (T)

### Magnetomotive Force

	* Ampere-turns (AT)
	* Gilberts (Gi)

### Mass

	* Carats (ct)
	* Grams (g)
	* Kilograms (kg)
	* Milligrams (mg)
	* Ounces (oz)
	* Pounds (lb)
	* Stones (stone)
	* Tonnes (tonne)

### Pressure

	* Atmospheres (atm)
	* Bars (b)
	* Pascals (Pa)
	* Psi (psi)
	* Torrs (Torr)

### Speed

	* Feet Per Second (fps)
	* Kilometres Per Hour (kph)
	* Knots (knot)
	* Metres Per Second (mps)
	* Miles Per Hour (mph)

### Temperature

	* Celsius (C)
	* Fahrenheit (F)
	* Kelvin (K)
	* Rankine (R)

### Time

	* Centuries (century)
	* Days (day)
	* Decades (decade)
	* Hours (hour)
	* Minutes (minute)
	* Months (month)
	* Seconds (second)
	* Weeks (week)
	* Years (year)

### Volume

	* Fluid Ounces (floz)
	* Gallons (gal)
	* Kilolitres (kl)
	* Litres (l)
	* Millilitres (ml)
	* Pints (pt)
	* Quarts (qt)
	* Tablespoons (tbsp)
	* Teaspoons (tsp)
	* US Cups (uscup)
	* US Fluid Ounces (usfloz)
	* US Gallons (usgal)
	* US Pints (uspt)
	* US Quarts (usqt)
	* US Tablespoons (ustbsp)
	* US Teaspoons (ustsp)

