// <auto-generated>
// This code was generated by the UnitCodeGenerator tool
//
// Changes to this file will be lost if the code is regenerated
// </auto-generated>

/// Pressure conversion functions
pub mod pressure {
	/// Atmospheres conversion functions
	pub mod atmospheres {
		/// Converts the supplied Atmospheres value to Bars
		/// # Arguments
		/// * `value` - The Atmospheres input value
		pub fn to_bars(value: f64) -> f64 {
			return value * 1.01325;
		}
		/// Converts the supplied Atmospheres value to Pascals
		/// # Arguments
		/// * `value` - The Atmospheres input value
		pub fn to_pascals(value: f64) -> f64 {
			return value * 101325.0;
		}
		/// Converts the supplied Atmospheres value to Torrs
		/// # Arguments
		/// * `value` - The Atmospheres input value
		pub fn to_torrs(value: f64) -> f64 {
			return value * 760.0;
		}
		/// Converts the supplied Atmospheres value to Psi
		/// # Arguments
		/// * `value` - The Atmospheres input value
		pub fn to_psi(value: f64) -> f64 {
			return value * 14.69596432068;
		}
	}
	/// Bars conversion functions
	pub mod bars {
		/// Converts the supplied Bars value to Atmospheres
		/// # Arguments
		/// * `value` - The Bars input value
		pub fn to_atmospheres(value: f64) -> f64 {
			return value / 1.01325;
		}
		/// Converts the supplied Bars value to Pascals
		/// # Arguments
		/// * `value` - The Bars input value
		pub fn to_pascals(value: f64) -> f64 {
			return value / 0.00001;
		}
		/// Converts the supplied Bars value to Torrs
		/// # Arguments
		/// * `value` - The Bars input value
		pub fn to_torrs(value: f64) -> f64 {
			return value * 750.0616827042;
		}
		/// Converts the supplied Bars value to Psi
		/// # Arguments
		/// * `value` - The Bars input value
		pub fn to_psi(value: f64) -> f64 {
			return value * 14.50378911491;
		}
	}
	/// Pascals conversion functions
	pub mod pascals {
		/// Converts the supplied Pascals value to Atmospheres
		/// # Arguments
		/// * `value` - The Pascals input value
		pub fn to_atmospheres(value: f64) -> f64 {
			return value / 101325.0;
		}
		/// Converts the supplied Pascals value to Bars
		/// # Arguments
		/// * `value` - The Pascals input value
		pub fn to_bars(value: f64) -> f64 {
			return value * 0.00001;
		}
		/// Converts the supplied Pascals value to Torrs
		/// # Arguments
		/// * `value` - The Pascals input value
		pub fn to_torrs(value: f64) -> f64 {
			return value * 0.007500616827042;
		}
		/// Converts the supplied Pascals value to Psi
		/// # Arguments
		/// * `value` - The Pascals input value
		pub fn to_psi(value: f64) -> f64 {
			return value * 0.0001450378911491;
		}
	}
	/// Psi conversion functions
	pub mod psi {
		/// Converts the supplied Psi value to Bars
		/// # Arguments
		/// * `value` - The Psi input value
		pub fn to_bars(value: f64) -> f64 {
			return value / 14.50378911491;
		}
		/// Converts the supplied Psi value to Pascals
		/// # Arguments
		/// * `value` - The Psi input value
		pub fn to_pascals(value: f64) -> f64 {
			return value / 0.0001450378911491;
		}
		/// Converts the supplied Psi value to Atmospheres
		/// # Arguments
		/// * `value` - The Psi input value
		pub fn to_atmospheres(value: f64) -> f64 {
			return value / 14.69596432068;
		}
		/// Converts the supplied Psi value to Torrs
		/// # Arguments
		/// * `value` - The Psi input value
		pub fn to_torrs(value: f64) -> f64 {
			return value / 0.01933679515879;
		}
	}
	/// Torrs conversion functions
	pub mod torrs {
		/// Converts the supplied Torrs value to Bars
		/// # Arguments
		/// * `value` - The Torrs input value
		pub fn to_bars(value: f64) -> f64 {
			return value / 750.0616827042;
		}
		/// Converts the supplied Torrs value to Pascals
		/// # Arguments
		/// * `value` - The Torrs input value
		pub fn to_pascals(value: f64) -> f64 {
			return value / 0.007500616827042;
		}
		/// Converts the supplied Torrs value to Atmospheres
		/// # Arguments
		/// * `value` - The Torrs input value
		pub fn to_atmospheres(value: f64) -> f64 {
			return value / 760.0;
		}
		/// Converts the supplied Torrs value to Psi
		/// # Arguments
		/// * `value` - The Torrs input value
		pub fn to_psi(value: f64) -> f64 {
			return value * 0.01933679515879;
		}
	}
}

#[cfg(test)]
mod tests {
	use super::*;
	use assert_approx_eq::assert_approx_eq;

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownatmospheres_to_bars_1() {
		let result: f64 = pressure::atmospheres::to_bars(6.0);
		assert_approx_eq!(6.0795, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownatmospheres_to_bars_2() {
		let result: f64 = pressure::atmospheres::to_bars(1.2);
		assert_approx_eq!(1.2159, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownatmospheres_to_bars_3() {
		let result: f64 = pressure::atmospheres::to_bars(0.8);
		assert_approx_eq!(0.8106, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownatmospheres_to_pascals_1() {
		let result: f64 = pressure::atmospheres::to_pascals(0.8);
		assert_approx_eq!(81060.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownatmospheres_to_pascals_2() {
		let result: f64 = pressure::atmospheres::to_pascals(1.2);
		assert_approx_eq!(121590.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownatmospheres_to_pascals_3() {
		let result: f64 = pressure::atmospheres::to_pascals(0.45);
		assert_approx_eq!(45596.25, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownatmospheres_to_torrs_1() {
		let result: f64 = pressure::atmospheres::to_torrs(0.45);
		assert_approx_eq!(342.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownatmospheres_to_torrs_2() {
		let result: f64 = pressure::atmospheres::to_torrs(1.2);
		assert_approx_eq!(912.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownatmospheres_to_torrs_3() {
		let result: f64 = pressure::atmospheres::to_torrs(6.0);
		assert_approx_eq!(4560.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownatmospheres_to_psi_1() {
		let result: f64 = pressure::atmospheres::to_psi(6.0);
		assert_approx_eq!(88.1757, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownatmospheres_to_psi_2() {
		let result: f64 = pressure::atmospheres::to_psi(0.4);
		assert_approx_eq!(5.87838, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownatmospheres_to_psi_3() {
		let result: f64 = pressure::atmospheres::to_psi(1.2);
		assert_approx_eq!(17.6351, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbars_to_atmospheres_1() {
		let result: f64 = pressure::bars::to_atmospheres(800.0);
		assert_approx_eq!(789.539, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbars_to_atmospheres_2() {
		let result: f64 = pressure::bars::to_atmospheres(123.0);
		assert_approx_eq!(121.392, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbars_to_atmospheres_3() {
		let result: f64 = pressure::bars::to_atmospheres(89.0);
		assert_approx_eq!(87.8362, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbars_to_pascals_1() {
		let result: f64 = pressure::bars::to_pascals(0.89);
		assert_approx_eq!(89000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbars_to_pascals_2() {
		let result: f64 = pressure::bars::to_pascals(0.01);
		assert_approx_eq!(1000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbars_to_pascals_3() {
		let result: f64 = pressure::bars::to_pascals(0.123);
		assert_approx_eq!(12300.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbars_to_torrs_1() {
		let result: f64 = pressure::bars::to_torrs(0.123);
		assert_approx_eq!(92.257587, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbars_to_torrs_2() {
		let result: f64 = pressure::bars::to_torrs(2.0);
		assert_approx_eq!(1500.12, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbars_to_torrs_3() {
		let result: f64 = pressure::bars::to_torrs(8.9);
		assert_approx_eq!(6675.55, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbars_to_psi_1() {
		let result: f64 = pressure::bars::to_psi(8.1);
		assert_approx_eq!(117.481, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbars_to_psi_2() {
		let result: f64 = pressure::bars::to_psi(1001.0);
		assert_approx_eq!(14518.29290, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbars_to_psi_3() {
		let result: f64 = pressure::bars::to_psi(6.0);
		assert_approx_eq!(87.0226, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpascals_to_atmospheres_1() {
		let result: f64 = pressure::pascals::to_atmospheres(90000.0);
		assert_approx_eq!(0.88823094, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpascals_to_atmospheres_2() {
		let result: f64 = pressure::pascals::to_atmospheres(1234567.0);
		assert_approx_eq!(12.18422897, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpascals_to_atmospheres_3() {
		let result: f64 = pressure::pascals::to_atmospheres(204060.0);
		assert_approx_eq!(2.01391562, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpascals_to_bars_1() {
		let result: f64 = pressure::pascals::to_bars(10000.0);
		assert_approx_eq!(0.1, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpascals_to_bars_2() {
		let result: f64 = pressure::pascals::to_bars(12345.0);
		assert_approx_eq!(0.12345, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpascals_to_bars_3() {
		let result: f64 = pressure::pascals::to_bars(80000.0);
		assert_approx_eq!(0.8, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpascals_to_torrs_1() {
		let result: f64 = pressure::pascals::to_torrs(80000.0);
		assert_approx_eq!(600.04935, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpascals_to_torrs_2() {
		let result: f64 = pressure::pascals::to_torrs(1234.0);
		assert_approx_eq!(9.255761, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpascals_to_torrs_3() {
		let result: f64 = pressure::pascals::to_torrs(80.0);
		assert_approx_eq!(0.600049, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpascals_to_psi_1() {
		let result: f64 = pressure::pascals::to_psi(800.0);
		assert_approx_eq!(0.11603, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpascals_to_psi_2() {
		let result: f64 = pressure::pascals::to_psi(8670.0);
		assert_approx_eq!(1.257477, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpascals_to_psi_3() {
		let result: f64 = pressure::pascals::to_psi(1000.0);
		assert_approx_eq!(0.145038, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpsi_to_bars_1() {
		let result: f64 = pressure::psi::to_bars(900.0);
		assert_approx_eq!(62.0528, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpsi_to_bars_2() {
		let result: f64 = pressure::psi::to_bars(134.0);
		assert_approx_eq!(9.23897, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpsi_to_bars_3() {
		let result: f64 = pressure::psi::to_bars(111.2);
		assert_approx_eq!(7.6669701, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpsi_to_pascals_1() {
		let result: f64 = pressure::psi::to_pascals(0.9);
		assert_approx_eq!(6205.28, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpsi_to_pascals_2() {
		let result: f64 = pressure::psi::to_pascals(0.03);
		assert_approx_eq!(206.8427, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpsi_to_pascals_3() {
		let result: f64 = pressure::psi::to_pascals(2.0);
		assert_approx_eq!(13789.5, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpsi_to_atmospheres_1() {
		let result: f64 = pressure::psi::to_atmospheres(2.0);
		assert_approx_eq!(0.136092, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpsi_to_atmospheres_2() {
		let result: f64 = pressure::psi::to_atmospheres(109.0);
		assert_approx_eq!(7.41701, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpsi_to_atmospheres_3() {
		let result: f64 = pressure::psi::to_atmospheres(8.0);
		assert_approx_eq!(0.544368, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpsi_to_torrs_1() {
		let result: f64 = pressure::psi::to_torrs(6.0);
		assert_approx_eq!(310.29, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpsi_to_torrs_2() {
		let result: f64 = pressure::psi::to_torrs(3.4);
		assert_approx_eq!(175.831, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpsi_to_torrs_3() {
		let result: f64 = pressure::psi::to_torrs(0.5);
		assert_approx_eq!(25.8575, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowntorrs_to_bars_1() {
		let result: f64 = pressure::torrs::to_bars(100.0);
		assert_approx_eq!(0.133322, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowntorrs_to_bars_2() {
		let result: f64 = pressure::torrs::to_bars(9000.1);
		assert_approx_eq!(11.9991465, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowntorrs_to_bars_3() {
		let result: f64 = pressure::torrs::to_bars(1234.0);
		assert_approx_eq!(1.645198, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowntorrs_to_pascals_1() {
		let result: f64 = pressure::torrs::to_pascals(190.0);
		assert_approx_eq!(25331.2499, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowntorrs_to_pascals_2() {
		let result: f64 = pressure::torrs::to_pascals(6.5);
		assert_approx_eq!(866.595, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowntorrs_to_pascals_3() {
		let result: f64 = pressure::torrs::to_pascals(3.4);
		assert_approx_eq!(453.296, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowntorrs_to_atmospheres_1() {
		let result: f64 = pressure::torrs::to_atmospheres(5678.0);
		assert_approx_eq!(7.471053, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowntorrs_to_atmospheres_2() {
		let result: f64 = pressure::torrs::to_atmospheres(100.0);
		assert_approx_eq!(0.131579, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowntorrs_to_atmospheres_3() {
		let result: f64 = pressure::torrs::to_atmospheres(4509.0);
		assert_approx_eq!(5.932895, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowntorrs_to_psi_1() {
		let result: f64 = pressure::torrs::to_psi(4500.0);
		assert_approx_eq!(87.01549, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowntorrs_to_psi_2() {
		let result: f64 = pressure::torrs::to_psi(1234.0);
		assert_approx_eq!(23.86158, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowntorrs_to_psi_3() {
		let result: f64 = pressure::torrs::to_psi(900.0);
		assert_approx_eq!(17.4031, result, 0.01);
	}

}
