// <auto-generated>
// This code was generated by the UnitCodeGenerator tool
//
// Changes to this file will be lost if the code is regenerated
// </auto-generated>

/// Force conversion functions
pub mod force {
	/// Dynes conversion functions
	pub mod dynes {
		/// Converts the supplied Dynes value to Newtons
		/// # Arguments
		/// * `value` - The Dynes input value
		pub fn to_newtons(value: f64) -> f64 {
			return value / 100000.0;
		}
		/// Converts the supplied Dynes value to Poundals
		/// # Arguments
		/// * `value` - The Dynes input value
		pub fn to_poundals(value: f64) -> f64 {
			return value / 13825.4954376;
		}
		/// Converts the supplied Dynes value to Kilogram-force
		/// # Arguments
		/// * `value` - The Dynes input value
		pub fn to_kilogramforce(value: f64) -> f64 {
			return value / 980665.0;
		}
	}
	/// Kilogram-force conversion functions
	pub mod kilogramforce {
		/// Converts the supplied Kilogram-force value to Newtons
		/// # Arguments
		/// * `value` - The Kilogram-force input value
		pub fn to_newtons(value: f64) -> f64 {
			return value * 9.80665;
		}
		/// Converts the supplied Kilogram-force value to Dynes
		/// # Arguments
		/// * `value` - The Kilogram-force input value
		pub fn to_dynes(value: f64) -> f64 {
			return value * 980665.0;
		}
		/// Converts the supplied Kilogram-force value to Poundals
		/// # Arguments
		/// * `value` - The Kilogram-force input value
		pub fn to_poundals(value: f64) -> f64 {
			return value * 70.93163528397;
		}
	}
	/// Newtons conversion functions
	pub mod newtons {
		/// Converts the supplied Newtons value to Dynes
		/// # Arguments
		/// * `value` - The Newtons input value
		pub fn to_dynes(value: f64) -> f64 {
			return value * 100000.0;
		}
		/// Converts the supplied Newtons value to Poundals
		/// # Arguments
		/// * `value` - The Newtons input value
		pub fn to_poundals(value: f64) -> f64 {
			return value * 7.23301;
		}
		/// Converts the supplied Newtons value to Kilogram-force
		/// # Arguments
		/// * `value` - The Newtons input value
		pub fn to_kilogramforce(value: f64) -> f64 {
			return value / 9.80665;
		}
	}
	/// Poundals conversion functions
	pub mod poundals {
		/// Converts the supplied Poundals value to Newtons
		/// # Arguments
		/// * `value` - The Poundals input value
		pub fn to_newtons(value: f64) -> f64 {
			return value / 7.23301;
		}
		/// Converts the supplied Poundals value to Dynes
		/// # Arguments
		/// * `value` - The Poundals input value
		pub fn to_dynes(value: f64) -> f64 {
			return value * 13825.4954376;
		}
		/// Converts the supplied Poundals value to Kilogram-force
		/// # Arguments
		/// * `value` - The Poundals input value
		pub fn to_kilogramforce(value: f64) -> f64 {
			return value / 70.93163528397;
		}
	}
}

#[cfg(test)]
mod tests {
	use super::*;
	use assert_approx_eq::assert_approx_eq;

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowndynes_to_newtons_1() {
		let result: f64 = force::dynes::to_newtons(900.0);
		assert_approx_eq!(0.009, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowndynes_to_newtons_2() {
		let result: f64 = force::dynes::to_newtons(1234.0);
		assert_approx_eq!(0.01234, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowndynes_to_newtons_3() {
		let result: f64 = force::dynes::to_newtons(46.0);
		assert_approx_eq!(0.00046, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowndynes_to_poundals_1() {
		let result: f64 = force::dynes::to_poundals(10099.0);
		assert_approx_eq!(0.73046207, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowndynes_to_poundals_2() {
		let result: f64 = force::dynes::to_poundals(80000.0);
		assert_approx_eq!(5.7864111, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowndynes_to_poundals_3() {
		let result: f64 = force::dynes::to_poundals(12345.0);
		assert_approx_eq!(0.89291556, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowndynes_to_kilogramforce_1() {
		let result: f64 = force::dynes::to_kilogramforce(123456.0);
		assert_approx_eq!(0.125890085, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowndynes_to_kilogramforce_2() {
		let result: f64 = force::dynes::to_kilogramforce(80000.0);
		assert_approx_eq!(0.081577297, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowndynes_to_kilogramforce_3() {
		let result: f64 = force::dynes::to_kilogramforce(987654321.0);
		assert_approx_eq!(1007.12712394, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilogramforce_to_newtons_1() {
		let result: f64 = force::kilogramforce::to_newtons(16.0);
		assert_approx_eq!(156.906, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilogramforce_to_newtons_2() {
		let result: f64 = force::kilogramforce::to_newtons(9.3);
		assert_approx_eq!(91.2018, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilogramforce_to_newtons_3() {
		let result: f64 = force::kilogramforce::to_newtons(5.0);
		assert_approx_eq!(49.0332, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilogramforce_to_dynes_1() {
		let result: f64 = force::kilogramforce::to_dynes(0.1);
		assert_approx_eq!(98066.5, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilogramforce_to_dynes_2() {
		let result: f64 = force::kilogramforce::to_dynes(0.009);
		assert_approx_eq!(8825.985, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilogramforce_to_dynes_3() {
		let result: f64 = force::kilogramforce::to_dynes(2.0);
		assert_approx_eq!(1961330.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilogramforce_to_poundals_1() {
		let result: f64 = force::kilogramforce::to_poundals(2.0);
		assert_approx_eq!(141.863, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilogramforce_to_poundals_2() {
		let result: f64 = force::kilogramforce::to_poundals(8.4);
		assert_approx_eq!(595.826, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilogramforce_to_poundals_3() {
		let result: f64 = force::kilogramforce::to_poundals(0.9);
		assert_approx_eq!(63.8385, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownnewtons_to_dynes_1() {
		let result: f64 = force::newtons::to_dynes(0.7);
		assert_approx_eq!(70000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownnewtons_to_dynes_2() {
		let result: f64 = force::newtons::to_dynes(0.08);
		assert_approx_eq!(8000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownnewtons_to_dynes_3() {
		let result: f64 = force::newtons::to_dynes(2.3);
		assert_approx_eq!(230000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownnewtons_to_poundals_1() {
		let result: f64 = force::newtons::to_poundals(190.0);
		assert_approx_eq!(1374.27, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownnewtons_to_poundals_2() {
		let result: f64 = force::newtons::to_poundals(0.7);
		assert_approx_eq!(5.06311, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownnewtons_to_poundals_3() {
		let result: f64 = force::newtons::to_poundals(89.0);
		assert_approx_eq!(643.738, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownnewtons_to_kilogramforce_1() {
		let result: f64 = force::newtons::to_kilogramforce(8.7);
		assert_approx_eq!(0.887153, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownnewtons_to_kilogramforce_2() {
		let result: f64 = force::newtons::to_kilogramforce(109.0);
		assert_approx_eq!(11.1149, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownnewtons_to_kilogramforce_3() {
		let result: f64 = force::newtons::to_kilogramforce(6.9);
		assert_approx_eq!(0.703604, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpoundals_to_newtons_1() {
		let result: f64 = force::poundals::to_newtons(800.0);
		assert_approx_eq!(110.604, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpoundals_to_newtons_2() {
		let result: f64 = force::poundals::to_newtons(8.2);
		assert_approx_eq!(1.13369, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpoundals_to_newtons_3() {
		let result: f64 = force::poundals::to_newtons(190.0);
		assert_approx_eq!(26.2684, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpoundals_to_dynes_1() {
		let result: f64 = force::poundals::to_dynes(0.01);
		assert_approx_eq!(138.255, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpoundals_to_dynes_2() {
		let result: f64 = force::poundals::to_dynes(2.0);
		assert_approx_eq!(27651.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpoundals_to_dynes_3() {
		let result: f64 = force::poundals::to_dynes(0.9);
		assert_approx_eq!(12442.94589384, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpoundals_to_kilogramforce_1() {
		let result: f64 = force::poundals::to_kilogramforce(34.0);
		assert_approx_eq!(0.479335, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpoundals_to_kilogramforce_2() {
		let result: f64 = force::poundals::to_kilogramforce(101.1);
		assert_approx_eq!(1.4253161, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownpoundals_to_kilogramforce_3() {
		let result: f64 = force::poundals::to_kilogramforce(9.5);
		assert_approx_eq!(0.133932, result, 0.01);
	}

}
