// <auto-generated>
// This code was generated by the UnitCodeGenerator tool
//
// Changes to this file will be lost if the code is regenerated
// </auto-generated>

/// Data Storage conversion functions
pub mod data_storage {
	/// Bits conversion functions
	pub mod bits {
		/// Converts the supplied Bits value to Kilobits
		/// # Arguments
		/// * `value` - The Bits input value
		pub fn to_kilobits(value: f64) -> f64 {
			return value / 1000.0;
		}
		/// Converts the supplied Bits value to Megabits
		/// # Arguments
		/// * `value` - The Bits input value
		pub fn to_megabits(value: f64) -> f64 {
			return value / 1e+6;
		}
		/// Converts the supplied Bits value to Gigabits
		/// # Arguments
		/// * `value` - The Bits input value
		pub fn to_gigabits(value: f64) -> f64 {
			return value / 1e+9;
		}
		/// Converts the supplied Bits value to Terabits
		/// # Arguments
		/// * `value` - The Bits input value
		pub fn to_terabits(value: f64) -> f64 {
			return value / 1e+12;
		}
		/// Converts the supplied Bits value to Kilobytes
		/// # Arguments
		/// * `value` - The Bits input value
		pub fn to_kilobytes(value: f64) -> f64 {
			return value / 8000.0;
		}
		/// Converts the supplied Bits value to Megabytes
		/// # Arguments
		/// * `value` - The Bits input value
		pub fn to_megabytes(value: f64) -> f64 {
			return value / 8e+6;
		}
		/// Converts the supplied Bits value to Gigabytes
		/// # Arguments
		/// * `value` - The Bits input value
		pub fn to_gigabytes(value: f64) -> f64 {
			return value / 8e+9;
		}
		/// Converts the supplied Bits value to Terabytes
		/// # Arguments
		/// * `value` - The Bits input value
		pub fn to_terabytes(value: f64) -> f64 {
			return value / 8e+12;
		}
		/// Converts the supplied Bits value to Kibibits
		/// # Arguments
		/// * `value` - The Bits input value
		pub fn to_kibibits(value: f64) -> f64 {
			return value / 1024.0;
		}
		/// Converts the supplied Bits value to Mebibits
		/// # Arguments
		/// * `value` - The Bits input value
		pub fn to_mebibits(value: f64) -> f64 {
			return value / 1048576.0;
		}
	}
	/// Gigabits conversion functions
	pub mod gigabits {
		/// Converts the supplied Gigabits value to Bits
		/// # Arguments
		/// * `value` - The Gigabits input value
		pub fn to_bits(value: f64) -> f64 {
			return value * 1e+9;
		}
		/// Converts the supplied Gigabits value to Kilobits
		/// # Arguments
		/// * `value` - The Gigabits input value
		pub fn to_kilobits(value: f64) -> f64 {
			return value * 1e+6;
		}
		/// Converts the supplied Gigabits value to Megabits
		/// # Arguments
		/// * `value` - The Gigabits input value
		pub fn to_megabits(value: f64) -> f64 {
			return value * 1000.0;
		}
		/// Converts the supplied Gigabits value to Terabits
		/// # Arguments
		/// * `value` - The Gigabits input value
		pub fn to_terabits(value: f64) -> f64 {
			return value / 1000.0;
		}
		/// Converts the supplied Gigabits value to Kilobytes
		/// # Arguments
		/// * `value` - The Gigabits input value
		pub fn to_kilobytes(value: f64) -> f64 {
			return value * 125000.0;
		}
		/// Converts the supplied Gigabits value to Megabytes
		/// # Arguments
		/// * `value` - The Gigabits input value
		pub fn to_megabytes(value: f64) -> f64 {
			return value * 125.0;
		}
		/// Converts the supplied Gigabits value to Gigabytes
		/// # Arguments
		/// * `value` - The Gigabits input value
		pub fn to_gigabytes(value: f64) -> f64 {
			return value / 8.0;
		}
		/// Converts the supplied Gigabits value to Terabytes
		/// # Arguments
		/// * `value` - The Gigabits input value
		pub fn to_terabytes(value: f64) -> f64 {
			return value / 8000.0;
		}
		/// Converts the supplied Gigabits value to Kibibits
		/// # Arguments
		/// * `value` - The Gigabits input value
		pub fn to_kibibits(value: f64) -> f64 {
			return value * 976562.5;
		}
		/// Converts the supplied Gigabits value to Mebibits
		/// # Arguments
		/// * `value` - The Gigabits input value
		pub fn to_mebibits(value: f64) -> f64 {
			return value * 953.67431640625;
		}
	}
	/// Gigabytes conversion functions
	pub mod gigabytes {
		/// Converts the supplied Gigabytes value to Bits
		/// # Arguments
		/// * `value` - The Gigabytes input value
		pub fn to_bits(value: f64) -> f64 {
			return value * 8e+9;
		}
		/// Converts the supplied Gigabytes value to Kilobits
		/// # Arguments
		/// * `value` - The Gigabytes input value
		pub fn to_kilobits(value: f64) -> f64 {
			return value * 8e+6;
		}
		/// Converts the supplied Gigabytes value to Megabits
		/// # Arguments
		/// * `value` - The Gigabytes input value
		pub fn to_megabits(value: f64) -> f64 {
			return value * 8000.0;
		}
		/// Converts the supplied Gigabytes value to Gigabits
		/// # Arguments
		/// * `value` - The Gigabytes input value
		pub fn to_gigabits(value: f64) -> f64 {
			return value * 8.0;
		}
		/// Converts the supplied Gigabytes value to Terabits
		/// # Arguments
		/// * `value` - The Gigabytes input value
		pub fn to_terabits(value: f64) -> f64 {
			return value / 125.0;
		}
		/// Converts the supplied Gigabytes value to Kilobytes
		/// # Arguments
		/// * `value` - The Gigabytes input value
		pub fn to_kilobytes(value: f64) -> f64 {
			return value * 1e+6;
		}
		/// Converts the supplied Gigabytes value to Megabytes
		/// # Arguments
		/// * `value` - The Gigabytes input value
		pub fn to_megabytes(value: f64) -> f64 {
			return value * 1000.0;
		}
		/// Converts the supplied Gigabytes value to Terabytes
		/// # Arguments
		/// * `value` - The Gigabytes input value
		pub fn to_terabytes(value: f64) -> f64 {
			return value / 1000.0;
		}
		/// Converts the supplied Gigabytes value to Kibibits
		/// # Arguments
		/// * `value` - The Gigabytes input value
		pub fn to_kibibits(value: f64) -> f64 {
			return value * 7812500.0;
		}
		/// Converts the supplied Gigabytes value to Mebibits
		/// # Arguments
		/// * `value` - The Gigabytes input value
		pub fn to_mebibits(value: f64) -> f64 {
			return value * 7629.39;
		}
	}
	/// Kibibits conversion functions
	pub mod kibibits {
		/// Converts the supplied Kibibits value to Bits
		/// # Arguments
		/// * `value` - The Kibibits input value
		pub fn to_bits(value: f64) -> f64 {
			return value * 1024.0;
		}
		/// Converts the supplied Kibibits value to Kilobits
		/// # Arguments
		/// * `value` - The Kibibits input value
		pub fn to_kilobits(value: f64) -> f64 {
			return value * 1.024;
		}
		/// Converts the supplied Kibibits value to Megabits
		/// # Arguments
		/// * `value` - The Kibibits input value
		pub fn to_megabits(value: f64) -> f64 {
			return value / 976.563;
		}
		/// Converts the supplied Kibibits value to Gigabits
		/// # Arguments
		/// * `value` - The Kibibits input value
		pub fn to_gigabits(value: f64) -> f64 {
			return value / 976562.5;
		}
		/// Converts the supplied Kibibits value to Terabits
		/// # Arguments
		/// * `value` - The Kibibits input value
		pub fn to_terabits(value: f64) -> f64 {
			return value / 976562500.0;
		}
		/// Converts the supplied Kibibits value to Kilobytes
		/// # Arguments
		/// * `value` - The Kibibits input value
		pub fn to_kilobytes(value: f64) -> f64 {
			return value / 7.8125;
		}
		/// Converts the supplied Kibibits value to Megabytes
		/// # Arguments
		/// * `value` - The Kibibits input value
		pub fn to_megabytes(value: f64) -> f64 {
			return value / 7812.5;
		}
		/// Converts the supplied Kibibits value to Gigabytes
		/// # Arguments
		/// * `value` - The Kibibits input value
		pub fn to_gigabytes(value: f64) -> f64 {
			return value / 7812500.0;
		}
		/// Converts the supplied Kibibits value to Terabytes
		/// # Arguments
		/// * `value` - The Kibibits input value
		pub fn to_terabytes(value: f64) -> f64 {
			return value / 7812500000.0;
		}
		/// Converts the supplied Kibibits value to Mebibits
		/// # Arguments
		/// * `value` - The Kibibits input value
		pub fn to_mebibits(value: f64) -> f64 {
			return value / 1024.0;
		}
	}
	/// Kilobits conversion functions
	pub mod kilobits {
		/// Converts the supplied Kilobits value to Bits
		/// # Arguments
		/// * `value` - The Kilobits input value
		pub fn to_bits(value: f64) -> f64 {
			return value * 1000.0;
		}
		/// Converts the supplied Kilobits value to Megabits
		/// # Arguments
		/// * `value` - The Kilobits input value
		pub fn to_megabits(value: f64) -> f64 {
			return value / 1000.0;
		}
		/// Converts the supplied Kilobits value to Gigabits
		/// # Arguments
		/// * `value` - The Kilobits input value
		pub fn to_gigabits(value: f64) -> f64 {
			return value / 1e+6;
		}
		/// Converts the supplied Kilobits value to Terabits
		/// # Arguments
		/// * `value` - The Kilobits input value
		pub fn to_terabits(value: f64) -> f64 {
			return value / 1e+9;
		}
		/// Converts the supplied Kilobits value to Kilobytes
		/// # Arguments
		/// * `value` - The Kilobits input value
		pub fn to_kilobytes(value: f64) -> f64 {
			return value / 8.0;
		}
		/// Converts the supplied Kilobits value to Megabytes
		/// # Arguments
		/// * `value` - The Kilobits input value
		pub fn to_megabytes(value: f64) -> f64 {
			return value / 8000.0;
		}
		/// Converts the supplied Kilobits value to Gigabytes
		/// # Arguments
		/// * `value` - The Kilobits input value
		pub fn to_gigabytes(value: f64) -> f64 {
			return value / 8e+6;
		}
		/// Converts the supplied Kilobits value to Terabytes
		/// # Arguments
		/// * `value` - The Kilobits input value
		pub fn to_terabytes(value: f64) -> f64 {
			return value / 8e+9;
		}
		/// Converts the supplied Kilobits value to Kibibits
		/// # Arguments
		/// * `value` - The Kilobits input value
		pub fn to_kibibits(value: f64) -> f64 {
			return value / 1.024;
		}
		/// Converts the supplied Kilobits value to Mebibits
		/// # Arguments
		/// * `value` - The Kilobits input value
		pub fn to_mebibits(value: f64) -> f64 {
			return value / 1048.58;
		}
	}
	/// Kilobytes conversion functions
	pub mod kilobytes {
		/// Converts the supplied Kilobytes value to Bits
		/// # Arguments
		/// * `value` - The Kilobytes input value
		pub fn to_bits(value: f64) -> f64 {
			return value * 8000.0;
		}
		/// Converts the supplied Kilobytes value to Kilobits
		/// # Arguments
		/// * `value` - The Kilobytes input value
		pub fn to_kilobits(value: f64) -> f64 {
			return value * 8.0;
		}
		/// Converts the supplied Kilobytes value to Megabits
		/// # Arguments
		/// * `value` - The Kilobytes input value
		pub fn to_megabits(value: f64) -> f64 {
			return value / 125.0;
		}
		/// Converts the supplied Kilobytes value to Gigabits
		/// # Arguments
		/// * `value` - The Kilobytes input value
		pub fn to_gigabits(value: f64) -> f64 {
			return value / 125000.0;
		}
		/// Converts the supplied Kilobytes value to Terabits
		/// # Arguments
		/// * `value` - The Kilobytes input value
		pub fn to_terabits(value: f64) -> f64 {
			return value / 1.25e+8;
		}
		/// Converts the supplied Kilobytes value to Megabytes
		/// # Arguments
		/// * `value` - The Kilobytes input value
		pub fn to_megabytes(value: f64) -> f64 {
			return value / 1000.0;
		}
		/// Converts the supplied Kilobytes value to Gigabytes
		/// # Arguments
		/// * `value` - The Kilobytes input value
		pub fn to_gigabytes(value: f64) -> f64 {
			return value / 1e+6;
		}
		/// Converts the supplied Kilobytes value to Terabytes
		/// # Arguments
		/// * `value` - The Kilobytes input value
		pub fn to_terabytes(value: f64) -> f64 {
			return value / 1e+9;
		}
		/// Converts the supplied Kilobytes value to Kibibits
		/// # Arguments
		/// * `value` - The Kilobytes input value
		pub fn to_kibibits(value: f64) -> f64 {
			return value * 7.8125;
		}
		/// Converts the supplied Kilobytes value to Mebibits
		/// # Arguments
		/// * `value` - The Kilobytes input value
		pub fn to_mebibits(value: f64) -> f64 {
			return value * 0.00762939;
		}
	}
	/// Mebibits conversion functions
	pub mod mebibits {
		/// Converts the supplied Mebibits value to Bits
		/// # Arguments
		/// * `value` - The Mebibits input value
		pub fn to_bits(value: f64) -> f64 {
			return value * 1048576.0;
		}
		/// Converts the supplied Mebibits value to Kilobits
		/// # Arguments
		/// * `value` - The Mebibits input value
		pub fn to_kilobits(value: f64) -> f64 {
			return value * 1048.58;
		}
		/// Converts the supplied Mebibits value to Megabits
		/// # Arguments
		/// * `value` - The Mebibits input value
		pub fn to_megabits(value: f64) -> f64 {
			return value * 1.04858;
		}
		/// Converts the supplied Mebibits value to Gigabits
		/// # Arguments
		/// * `value` - The Mebibits input value
		pub fn to_gigabits(value: f64) -> f64 {
			return value / 953.67431640625;
		}
		/// Converts the supplied Mebibits value to Terabits
		/// # Arguments
		/// * `value` - The Mebibits input value
		pub fn to_terabits(value: f64) -> f64 {
			return value / 953674.0;
		}
		/// Converts the supplied Mebibits value to Kilobytes
		/// # Arguments
		/// * `value` - The Mebibits input value
		pub fn to_kilobytes(value: f64) -> f64 {
			return value / 0.00762939;
		}
		/// Converts the supplied Mebibits value to Megabytes
		/// # Arguments
		/// * `value` - The Mebibits input value
		pub fn to_megabytes(value: f64) -> f64 {
			return value / 7.62939;
		}
		/// Converts the supplied Mebibits value to Gigabytes
		/// # Arguments
		/// * `value` - The Mebibits input value
		pub fn to_gigabytes(value: f64) -> f64 {
			return value / 7629.39;
		}
		/// Converts the supplied Mebibits value to Terabytes
		/// # Arguments
		/// * `value` - The Mebibits input value
		pub fn to_terabytes(value: f64) -> f64 {
			return value * 0.000000131072;
		}
		/// Converts the supplied Mebibits value to Kibibits
		/// # Arguments
		/// * `value` - The Mebibits input value
		pub fn to_kibibits(value: f64) -> f64 {
			return value * 1024.0;
		}
	}
	/// Megabits conversion functions
	pub mod megabits {
		/// Converts the supplied Megabits value to Bits
		/// # Arguments
		/// * `value` - The Megabits input value
		pub fn to_bits(value: f64) -> f64 {
			return value * 1e+6;
		}
		/// Converts the supplied Megabits value to Kilobits
		/// # Arguments
		/// * `value` - The Megabits input value
		pub fn to_kilobits(value: f64) -> f64 {
			return value * 1000.0;
		}
		/// Converts the supplied Megabits value to Gigabits
		/// # Arguments
		/// * `value` - The Megabits input value
		pub fn to_gigabits(value: f64) -> f64 {
			return value / 1000.0;
		}
		/// Converts the supplied Megabits value to Terabits
		/// # Arguments
		/// * `value` - The Megabits input value
		pub fn to_terabits(value: f64) -> f64 {
			return value / 1e+6;
		}
		/// Converts the supplied Megabits value to Kilobytes
		/// # Arguments
		/// * `value` - The Megabits input value
		pub fn to_kilobytes(value: f64) -> f64 {
			return value * 125.0;
		}
		/// Converts the supplied Megabits value to Megabytes
		/// # Arguments
		/// * `value` - The Megabits input value
		pub fn to_megabytes(value: f64) -> f64 {
			return value / 8.0;
		}
		/// Converts the supplied Megabits value to Gigabytes
		/// # Arguments
		/// * `value` - The Megabits input value
		pub fn to_gigabytes(value: f64) -> f64 {
			return value / 8000.0;
		}
		/// Converts the supplied Megabits value to Terabytes
		/// # Arguments
		/// * `value` - The Megabits input value
		pub fn to_terabytes(value: f64) -> f64 {
			return value / 8e+6;
		}
		/// Converts the supplied Megabits value to Kibibits
		/// # Arguments
		/// * `value` - The Megabits input value
		pub fn to_kibibits(value: f64) -> f64 {
			return value * 976.563;
		}
		/// Converts the supplied Megabits value to Mebibits
		/// # Arguments
		/// * `value` - The Megabits input value
		pub fn to_mebibits(value: f64) -> f64 {
			return value / 1.04858;
		}
	}
	/// Megabytes conversion functions
	pub mod megabytes {
		/// Converts the supplied Megabytes value to Bits
		/// # Arguments
		/// * `value` - The Megabytes input value
		pub fn to_bits(value: f64) -> f64 {
			return value * 8e+6;
		}
		/// Converts the supplied Megabytes value to Kilobits
		/// # Arguments
		/// * `value` - The Megabytes input value
		pub fn to_kilobits(value: f64) -> f64 {
			return value * 8000.0;
		}
		/// Converts the supplied Megabytes value to Megabits
		/// # Arguments
		/// * `value` - The Megabytes input value
		pub fn to_megabits(value: f64) -> f64 {
			return value * 8.0;
		}
		/// Converts the supplied Megabytes value to Gigabits
		/// # Arguments
		/// * `value` - The Megabytes input value
		pub fn to_gigabits(value: f64) -> f64 {
			return value / 125.0;
		}
		/// Converts the supplied Megabytes value to Terabits
		/// # Arguments
		/// * `value` - The Megabytes input value
		pub fn to_terabits(value: f64) -> f64 {
			return value / 125000.0;
		}
		/// Converts the supplied Megabytes value to Kilobytes
		/// # Arguments
		/// * `value` - The Megabytes input value
		pub fn to_kilobytes(value: f64) -> f64 {
			return value * 1000.0;
		}
		/// Converts the supplied Megabytes value to Gigabytes
		/// # Arguments
		/// * `value` - The Megabytes input value
		pub fn to_gigabytes(value: f64) -> f64 {
			return value / 1000.0;
		}
		/// Converts the supplied Megabytes value to Terabytes
		/// # Arguments
		/// * `value` - The Megabytes input value
		pub fn to_terabytes(value: f64) -> f64 {
			return value / 1e+6;
		}
		/// Converts the supplied Megabytes value to Kibibits
		/// # Arguments
		/// * `value` - The Megabytes input value
		pub fn to_kibibits(value: f64) -> f64 {
			return value * 7812.5;
		}
		/// Converts the supplied Megabytes value to Mebibits
		/// # Arguments
		/// * `value` - The Megabytes input value
		pub fn to_mebibits(value: f64) -> f64 {
			return value * 7.62939;
		}
	}
	/// Terabits conversion functions
	pub mod terabits {
		/// Converts the supplied Terabits value to Bits
		/// # Arguments
		/// * `value` - The Terabits input value
		pub fn to_bits(value: f64) -> f64 {
			return value * 1e+12;
		}
		/// Converts the supplied Terabits value to Kilobits
		/// # Arguments
		/// * `value` - The Terabits input value
		pub fn to_kilobits(value: f64) -> f64 {
			return value * 1e+9;
		}
		/// Converts the supplied Terabits value to Megabits
		/// # Arguments
		/// * `value` - The Terabits input value
		pub fn to_megabits(value: f64) -> f64 {
			return value * 1e+6;
		}
		/// Converts the supplied Terabits value to Gigabits
		/// # Arguments
		/// * `value` - The Terabits input value
		pub fn to_gigabits(value: f64) -> f64 {
			return value * 1000.0;
		}
		/// Converts the supplied Terabits value to Kilobytes
		/// # Arguments
		/// * `value` - The Terabits input value
		pub fn to_kilobytes(value: f64) -> f64 {
			return value * 1.25e+8;
		}
		/// Converts the supplied Terabits value to Megabytes
		/// # Arguments
		/// * `value` - The Terabits input value
		pub fn to_megabytes(value: f64) -> f64 {
			return value * 125000.0;
		}
		/// Converts the supplied Terabits value to Gigabytes
		/// # Arguments
		/// * `value` - The Terabits input value
		pub fn to_gigabytes(value: f64) -> f64 {
			return value * 125.0;
		}
		/// Converts the supplied Terabits value to Terabytes
		/// # Arguments
		/// * `value` - The Terabits input value
		pub fn to_terabytes(value: f64) -> f64 {
			return value / 8.0;
		}
		/// Converts the supplied Terabits value to Kibibits
		/// # Arguments
		/// * `value` - The Terabits input value
		pub fn to_kibibits(value: f64) -> f64 {
			return value * 976562500.0;
		}
		/// Converts the supplied Terabits value to Mebibits
		/// # Arguments
		/// * `value` - The Terabits input value
		pub fn to_mebibits(value: f64) -> f64 {
			return value * 953674.0;
		}
	}
	/// Terabytes conversion functions
	pub mod terabytes {
		/// Converts the supplied Terabytes value to Bits
		/// # Arguments
		/// * `value` - The Terabytes input value
		pub fn to_bits(value: f64) -> f64 {
			return value * 8e+12;
		}
		/// Converts the supplied Terabytes value to Kilobits
		/// # Arguments
		/// * `value` - The Terabytes input value
		pub fn to_kilobits(value: f64) -> f64 {
			return value * 8e+9;
		}
		/// Converts the supplied Terabytes value to Megabits
		/// # Arguments
		/// * `value` - The Terabytes input value
		pub fn to_megabits(value: f64) -> f64 {
			return value * 8e+6;
		}
		/// Converts the supplied Terabytes value to Gigabits
		/// # Arguments
		/// * `value` - The Terabytes input value
		pub fn to_gigabits(value: f64) -> f64 {
			return value * 8000.0;
		}
		/// Converts the supplied Terabytes value to Terabits
		/// # Arguments
		/// * `value` - The Terabytes input value
		pub fn to_terabits(value: f64) -> f64 {
			return value * 8.0;
		}
		/// Converts the supplied Terabytes value to Kilobytes
		/// # Arguments
		/// * `value` - The Terabytes input value
		pub fn to_kilobytes(value: f64) -> f64 {
			return value * 1e+9;
		}
		/// Converts the supplied Terabytes value to Megabytes
		/// # Arguments
		/// * `value` - The Terabytes input value
		pub fn to_megabytes(value: f64) -> f64 {
			return value * 1e+6;
		}
		/// Converts the supplied Terabytes value to Gigabytes
		/// # Arguments
		/// * `value` - The Terabytes input value
		pub fn to_gigabytes(value: f64) -> f64 {
			return value * 1000.0;
		}
		/// Converts the supplied Terabytes value to Kibibits
		/// # Arguments
		/// * `value` - The Terabytes input value
		pub fn to_kibibits(value: f64) -> f64 {
			return value * 7812500000.0;
		}
		/// Converts the supplied Terabytes value to Mebibits
		/// # Arguments
		/// * `value` - The Terabytes input value
		pub fn to_mebibits(value: f64) -> f64 {
			return value / 0.000000131072;
		}
	}
}

#[cfg(test)]
mod tests {
	use super::*;
	use assert_approx_eq::assert_approx_eq;

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_kilobits_1() {
		let result: f64 = data_storage::bits::to_kilobits(100.0);
		assert_approx_eq!(0.1, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_kilobits_2() {
		let result: f64 = data_storage::bits::to_kilobits(6021.0);
		assert_approx_eq!(6.021, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_kilobits_3() {
		let result: f64 = data_storage::bits::to_kilobits(9100.0);
		assert_approx_eq!(9.1, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_megabits_1() {
		let result: f64 = data_storage::bits::to_megabits(9000000.0);
		assert_approx_eq!(9.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_megabits_2() {
		let result: f64 = data_storage::bits::to_megabits(123456.0);
		assert_approx_eq!(0.123456, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_megabits_3() {
		let result: f64 = data_storage::bits::to_megabits(1900000.0);
		assert_approx_eq!(1.9, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_gigabits_1() {
		let result: f64 = data_storage::bits::to_gigabits(190000000.0);
		assert_approx_eq!(0.19, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_gigabits_2() {
		let result: f64 = data_storage::bits::to_gigabits(8009.0);
		assert_approx_eq!(8.009e-6, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_gigabits_3() {
		let result: f64 = data_storage::bits::to_gigabits(987654321.0);
		assert_approx_eq!(0.987654321, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_terabits_1() {
		let result: f64 = data_storage::bits::to_terabits(987654321234.0);
		assert_approx_eq!(0.987654321234, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_terabits_2() {
		let result: f64 = data_storage::bits::to_terabits(1234567890123456.0);
		assert_approx_eq!(1234.567890123455982, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_terabits_3() {
		let result: f64 = data_storage::bits::to_terabits(999888777666555.0);
		assert_approx_eq!(999.888777666555029, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_kilobytes_1() {
		let result: f64 = data_storage::bits::to_kilobytes(900.0);
		assert_approx_eq!(0.1125, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_kilobytes_2() {
		let result: f64 = data_storage::bits::to_kilobytes(12345.0);
		assert_approx_eq!(1.543125, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_kilobytes_3() {
		let result: f64 = data_storage::bits::to_kilobytes(6000.9);
		assert_approx_eq!(0.7501125, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_megabytes_1() {
		let result: f64 = data_storage::bits::to_megabytes(123456.0);
		assert_approx_eq!(0.015432, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_megabytes_2() {
		let result: f64 = data_storage::bits::to_megabytes(900800.0);
		assert_approx_eq!(0.1126, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_megabytes_3() {
		let result: f64 = data_storage::bits::to_megabytes(999888777.0);
		assert_approx_eq!(124.986097125, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_gigabytes_1() {
		let result: f64 = data_storage::bits::to_gigabytes(999888777.0);
		assert_approx_eq!(0.124986097125, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_gigabytes_2() {
		let result: f64 = data_storage::bits::to_gigabytes(1.9e+9);
		assert_approx_eq!(0.2375, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_gigabytes_3() {
		let result: f64 = data_storage::bits::to_gigabytes(80090077.0);
		assert_approx_eq!(0.010011259625, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_terabytes_1() {
		let result: f64 = data_storage::bits::to_terabytes(999888777666.0);
		assert_approx_eq!(0.12498609720825, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_terabytes_2() {
		let result: f64 = data_storage::bits::to_terabytes(12345678912345.0);
		assert_approx_eq!(1.5432098640431251, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_terabytes_3() {
		let result: f64 = data_storage::bits::to_terabytes(111999222888333.0);
		assert_approx_eq!(13.9999028610416243, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_kibibits_1() {
		let result: f64 = data_storage::bits::to_kibibits(1800.0);
		assert_approx_eq!(1.757813, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_kibibits_2() {
		let result: f64 = data_storage::bits::to_kibibits(888.0);
		assert_approx_eq!(0.867188, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_kibibits_3() {
		let result: f64 = data_storage::bits::to_kibibits(7687.0);
		assert_approx_eq!(7.506836, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_mebibits_1() {
		let result: f64 = data_storage::bits::to_mebibits(999888.0);
		assert_approx_eq!(0.953567505, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_mebibits_2() {
		let result: f64 = data_storage::bits::to_mebibits(1234567.0);
		assert_approx_eq!(1.17737484, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownbits_to_mebibits_3() {
		let result: f64 = data_storage::bits::to_mebibits(900800.0);
		assert_approx_eq!(0.859069824, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_bits_1() {
		let result: f64 = data_storage::gigabits::to_bits(0.0009);
		assert_approx_eq!(900000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_bits_2() {
		let result: f64 = data_storage::gigabits::to_bits(0.00007);
		assert_approx_eq!(70000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_bits_3() {
		let result: f64 = data_storage::gigabits::to_bits(1.2e-5);
		assert_approx_eq!(12000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_kilobits_1() {
		let result: f64 = data_storage::gigabits::to_kilobits(0.01);
		assert_approx_eq!(10000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_kilobits_2() {
		let result: f64 = data_storage::gigabits::to_kilobits(0.91);
		assert_approx_eq!(910000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_kilobits_3() {
		let result: f64 = data_storage::gigabits::to_kilobits(6.1);
		assert_approx_eq!(6.1e+6, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_megabits_1() {
		let result: f64 = data_storage::gigabits::to_megabits(6.1);
		assert_approx_eq!(6100.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_megabits_2() {
		let result: f64 = data_storage::gigabits::to_megabits(0.961);
		assert_approx_eq!(961.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_megabits_3() {
		let result: f64 = data_storage::gigabits::to_megabits(1.2e-3);
		assert_approx_eq!(1.2, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_terabits_1() {
		let result: f64 = data_storage::gigabits::to_terabits(1200.0);
		assert_approx_eq!(1.2, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_terabits_2() {
		let result: f64 = data_storage::gigabits::to_terabits(90012.0);
		assert_approx_eq!(90.012, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_terabits_3() {
		let result: f64 = data_storage::gigabits::to_terabits(8000.0);
		assert_approx_eq!(8.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_kilobytes_1() {
		let result: f64 = data_storage::gigabits::to_kilobytes(1.2);
		assert_approx_eq!(150000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_kilobytes_2() {
		let result: f64 = data_storage::gigabits::to_kilobytes(0.9);
		assert_approx_eq!(112500.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_kilobytes_3() {
		let result: f64 = data_storage::gigabits::to_kilobytes(0.001);
		assert_approx_eq!(125.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_megabytes_1() {
		let result: f64 = data_storage::gigabits::to_megabytes(0.9);
		assert_approx_eq!(112.5, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_megabytes_2() {
		let result: f64 = data_storage::gigabits::to_megabytes(1.2);
		assert_approx_eq!(150.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_megabytes_3() {
		let result: f64 = data_storage::gigabits::to_megabytes(80.1);
		assert_approx_eq!(10012.5, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_gigabytes_1() {
		let result: f64 = data_storage::gigabits::to_gigabytes(99.0);
		assert_approx_eq!(12.375, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_gigabytes_2() {
		let result: f64 = data_storage::gigabits::to_gigabytes(123.123);
		assert_approx_eq!(15.390375, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_gigabytes_3() {
		let result: f64 = data_storage::gigabits::to_gigabytes(8000.9);
		assert_approx_eq!(1000.1125, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_terabytes_1() {
		let result: f64 = data_storage::gigabits::to_terabytes(9000.0);
		assert_approx_eq!(1.125, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_terabytes_2() {
		let result: f64 = data_storage::gigabits::to_terabytes(1234567.0);
		assert_approx_eq!(154.320875, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_terabytes_3() {
		let result: f64 = data_storage::gigabits::to_terabytes(613.0);
		assert_approx_eq!(0.076625, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_kibibits_1() {
		let result: f64 = data_storage::gigabits::to_kibibits(0.8);
		assert_approx_eq!(781250.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_kibibits_2() {
		let result: f64 = data_storage::gigabits::to_kibibits(0.012);
		assert_approx_eq!(11718.75, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_kibibits_3() {
		let result: f64 = data_storage::gigabits::to_kibibits(0.002);
		assert_approx_eq!(1953.125, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_mebibits_1() {
		let result: f64 = data_storage::gigabits::to_mebibits(0.002);
		assert_approx_eq!(1.9073486, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_mebibits_2() {
		let result: f64 = data_storage::gigabits::to_mebibits(0.9);
		assert_approx_eq!(858.30688476562, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabits_to_mebibits_3() {
		let result: f64 = data_storage::gigabits::to_mebibits(6.1);
		assert_approx_eq!(5817.413330078125, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_bits_1() {
		let result: f64 = data_storage::gigabytes::to_bits(0.004);
		assert_approx_eq!(32000000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_bits_2() {
		let result: f64 = data_storage::gigabytes::to_bits(0.012);
		assert_approx_eq!(96000000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_bits_3() {
		let result: f64 = data_storage::gigabytes::to_bits(3e-9);
		assert_approx_eq!(24.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_kilobits_1() {
		let result: f64 = data_storage::gigabytes::to_kilobits(0.009);
		assert_approx_eq!(72000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_kilobits_2() {
		let result: f64 = data_storage::gigabytes::to_kilobits(1.2e-4);
		assert_approx_eq!(960.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_kilobits_3() {
		let result: f64 = data_storage::gigabytes::to_kilobits(0.0078);
		assert_approx_eq!(62400.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_megabits_1() {
		let result: f64 = data_storage::gigabytes::to_megabits(0.0078);
		assert_approx_eq!(62.4, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_megabits_2() {
		let result: f64 = data_storage::gigabytes::to_megabits(0.01);
		assert_approx_eq!(80.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_megabits_3() {
		let result: f64 = data_storage::gigabytes::to_megabits(0.001234);
		assert_approx_eq!(9.872, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_gigabits_1() {
		let result: f64 = data_storage::gigabytes::to_gigabits(5.0);
		assert_approx_eq!(40.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_gigabits_2() {
		let result: f64 = data_storage::gigabytes::to_gigabits(1.2);
		assert_approx_eq!(9.6, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_gigabits_3() {
		let result: f64 = data_storage::gigabytes::to_gigabits(0.01);
		assert_approx_eq!(0.08, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_terabits_1() {
		let result: f64 = data_storage::gigabytes::to_terabits(70.0);
		assert_approx_eq!(0.56, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_terabits_2() {
		let result: f64 = data_storage::gigabytes::to_terabits(9001.0);
		assert_approx_eq!(72.008, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_terabits_3() {
		let result: f64 = data_storage::gigabytes::to_terabits(768123.9);
		assert_approx_eq!(6144.9912, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_kilobytes_1() {
		let result: f64 = data_storage::gigabytes::to_kilobytes(0.2);
		assert_approx_eq!(200000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_kilobytes_2() {
		let result: f64 = data_storage::gigabytes::to_kilobytes(0.009);
		assert_approx_eq!(9000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_kilobytes_3() {
		let result: f64 = data_storage::gigabytes::to_kilobytes(0.00123);
		assert_approx_eq!(1230.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_megabytes_1() {
		let result: f64 = data_storage::gigabytes::to_megabytes(0.9);
		assert_approx_eq!(900.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_megabytes_2() {
		let result: f64 = data_storage::gigabytes::to_megabytes(12.0);
		assert_approx_eq!(12000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_megabytes_3() {
		let result: f64 = data_storage::gigabytes::to_megabytes(35.6);
		assert_approx_eq!(35600.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_terabytes_1() {
		let result: f64 = data_storage::gigabytes::to_terabytes(35.6);
		assert_approx_eq!(0.0356, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_terabytes_2() {
		let result: f64 = data_storage::gigabytes::to_terabytes(100.23);
		assert_approx_eq!(0.10023, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_terabytes_3() {
		let result: f64 = data_storage::gigabytes::to_terabytes(900100.0);
		assert_approx_eq!(900.1, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_kibibits_1() {
		let result: f64 = data_storage::gigabytes::to_kibibits(0.05);
		assert_approx_eq!(390625.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_kibibits_2() {
		let result: f64 = data_storage::gigabytes::to_kibibits(0.008);
		assert_approx_eq!(62500.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_kibibits_3() {
		let result: f64 = data_storage::gigabytes::to_kibibits(0.00123);
		assert_approx_eq!(9609.375, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_mebibits_1() {
		let result: f64 = data_storage::gigabytes::to_mebibits(0.009);
		assert_approx_eq!(68.66451, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_mebibits_2() {
		let result: f64 = data_storage::gigabytes::to_mebibits(1.2);
		assert_approx_eq!(9155.268, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knowngigabytes_to_mebibits_3() {
		let result: f64 = data_storage::gigabytes::to_mebibits(19.2);
		assert_approx_eq!(146484.288, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_bits_1() {
		let result: f64 = data_storage::kibibits::to_bits(2.0);
		assert_approx_eq!(2048.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_bits_2() {
		let result: f64 = data_storage::kibibits::to_bits(9.0);
		assert_approx_eq!(9216.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_bits_3() {
		let result: f64 = data_storage::kibibits::to_bits(17.8);
		assert_approx_eq!(18227.2, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_kilobits_1() {
		let result: f64 = data_storage::kibibits::to_kilobits(6.2);
		assert_approx_eq!(6.3488, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_kilobits_2() {
		let result: f64 = data_storage::kibibits::to_kilobits(0.9);
		assert_approx_eq!(0.9216, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_kilobits_3() {
		let result: f64 = data_storage::kibibits::to_kilobits(87.0);
		assert_approx_eq!(89.088, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_megabits_1() {
		let result: f64 = data_storage::kibibits::to_megabits(87.0);
		assert_approx_eq!(0.089088, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_megabits_2() {
		let result: f64 = data_storage::kibibits::to_megabits(12.34);
		assert_approx_eq!(0.01263616, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_megabits_3() {
		let result: f64 = data_storage::kibibits::to_megabits(123456.0);
		assert_approx_eq!(126.418879, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_gigabits_1() {
		let result: f64 = data_storage::kibibits::to_gigabits(123456.0);
		assert_approx_eq!(0.126418944, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_gigabits_2() {
		let result: f64 = data_storage::kibibits::to_gigabits(8000000.0);
		assert_approx_eq!(8.192, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_gigabits_3() {
		let result: f64 = data_storage::kibibits::to_gigabits(1276876.0);
		assert_approx_eq!(1.307521024, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_terabits_1() {
		let result: f64 = data_storage::kibibits::to_terabits(800000000.0);
		assert_approx_eq!(0.8192, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_terabits_2() {
		let result: f64 = data_storage::kibibits::to_terabits(1.5e12);
		assert_approx_eq!(1536.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_terabits_3() {
		let result: f64 = data_storage::kibibits::to_terabits(9999999.0);
		assert_approx_eq!(0.01023999898, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_kilobytes_1() {
		let result: f64 = data_storage::kibibits::to_kilobytes(919.0);
		assert_approx_eq!(117.632, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_kilobytes_2() {
		let result: f64 = data_storage::kibibits::to_kilobytes(77.4);
		assert_approx_eq!(9.9072, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_kilobytes_3() {
		let result: f64 = data_storage::kibibits::to_kilobytes(109.109);
		assert_approx_eq!(13.965952, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_megabytes_1() {
		let result: f64 = data_storage::kibibits::to_megabytes(1000.0);
		assert_approx_eq!(0.128, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_megabytes_2() {
		let result: f64 = data_storage::kibibits::to_megabytes(800.123);
		assert_approx_eq!(0.102415744, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_megabytes_3() {
		let result: f64 = data_storage::kibibits::to_megabytes(123456.0);
		assert_approx_eq!(15.802368, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_gigabytes_1() {
		let result: f64 = data_storage::kibibits::to_gigabytes(12345678.0);
		assert_approx_eq!(1.580347926, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_gigabytes_2() {
		let result: f64 = data_storage::kibibits::to_gigabytes(8e12);
		assert_approx_eq!(1024000.00, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_gigabytes_3() {
		let result: f64 = data_storage::kibibits::to_gigabytes(1.2e5);
		assert_approx_eq!(0.01536, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_terabytes_1() {
		let result: f64 = data_storage::kibibits::to_terabytes(120000000.0);
		assert_approx_eq!(0.01536, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_terabytes_2() {
		let result: f64 = data_storage::kibibits::to_terabytes(88e12);
		assert_approx_eq!(11264.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_terabytes_3() {
		let result: f64 = data_storage::kibibits::to_terabytes(9000000.0);
		assert_approx_eq!(0.009216, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_mebibits_1() {
		let result: f64 = data_storage::kibibits::to_mebibits(600.0);
		assert_approx_eq!(0.5859375, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_mebibits_2() {
		let result: f64 = data_storage::kibibits::to_mebibits(12345.0);
		assert_approx_eq!(12.055664, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkibibits_to_mebibits_3() {
		let result: f64 = data_storage::kibibits::to_mebibits(101.0);
		assert_approx_eq!(0.0986328, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_bits_1() {
		let result: f64 = data_storage::kilobits::to_bits(9.0);
		assert_approx_eq!(9000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_bits_2() {
		let result: f64 = data_storage::kilobits::to_bits(6.7);
		assert_approx_eq!(6700.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_bits_3() {
		let result: f64 = data_storage::kilobits::to_bits(1.2345);
		assert_approx_eq!(1234.5, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_megabits_1() {
		let result: f64 = data_storage::kilobits::to_megabits(900.0);
		assert_approx_eq!(0.9, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_megabits_2() {
		let result: f64 = data_storage::kilobits::to_megabits(12345.0);
		assert_approx_eq!(12.345, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_megabits_3() {
		let result: f64 = data_storage::kilobits::to_megabits(9988.0);
		assert_approx_eq!(9.988, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_gigabits_1() {
		let result: f64 = data_storage::kilobits::to_gigabits(123456.0);
		assert_approx_eq!(0.123456, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_gigabits_2() {
		let result: f64 = data_storage::kilobits::to_gigabits(8000700.0);
		assert_approx_eq!(8.0007, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_gigabits_3() {
		let result: f64 = data_storage::kilobits::to_gigabits(191987578.0);
		assert_approx_eq!(191.987578, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_terabits_1() {
		let result: f64 = data_storage::kilobits::to_terabits(191987578.0);
		assert_approx_eq!(0.191987578, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_terabits_2() {
		let result: f64 = data_storage::kilobits::to_terabits(9010081903.0);
		assert_approx_eq!(9.010081903, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_terabits_3() {
		let result: f64 = data_storage::kilobits::to_terabits(123456789.0);
		assert_approx_eq!(0.123456789, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_kilobytes_1() {
		let result: f64 = data_storage::kilobits::to_kilobytes(80.0);
		assert_approx_eq!(10.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_kilobytes_2() {
		let result: f64 = data_storage::kilobits::to_kilobytes(15.67);
		assert_approx_eq!(1.95875, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_kilobytes_3() {
		let result: f64 = data_storage::kilobits::to_kilobytes(8007.09);
		assert_approx_eq!(1000.88625, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_megabytes_1() {
		let result: f64 = data_storage::kilobits::to_megabytes(123456.0);
		assert_approx_eq!(15.432, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_megabytes_2() {
		let result: f64 = data_storage::kilobits::to_megabytes(998877.0);
		assert_approx_eq!(124.859625, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_megabytes_3() {
		let result: f64 = data_storage::kilobits::to_megabytes(10090.0);
		assert_approx_eq!(1.26125, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_gigabytes_1() {
		let result: f64 = data_storage::kilobits::to_gigabytes(1828972.0);
		assert_approx_eq!(0.2286215, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_gigabytes_2() {
		let result: f64 = data_storage::kilobits::to_gigabytes(879860.8);
		assert_approx_eq!(0.1099826, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_gigabytes_3() {
		let result: f64 = data_storage::kilobits::to_gigabytes(78178971.0);
		assert_approx_eq!(9.772371375, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_terabytes_1() {
		let result: f64 = data_storage::kilobits::to_terabytes(1234567891.0);
		assert_approx_eq!(0.154320986375, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_terabytes_2() {
		let result: f64 = data_storage::kilobits::to_terabytes(999999098.0);
		assert_approx_eq!(0.12499988725, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_terabytes_3() {
		let result: f64 = data_storage::kilobits::to_terabytes(84618364142.0);
		assert_approx_eq!(10.57729551775, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_kibibits_1() {
		let result: f64 = data_storage::kilobits::to_kibibits(89.1);
		assert_approx_eq!(87.01172, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_kibibits_2() {
		let result: f64 = data_storage::kilobits::to_kibibits(7.1);
		assert_approx_eq!(6.93359, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_kibibits_3() {
		let result: f64 = data_storage::kilobits::to_kibibits(438.0);
		assert_approx_eq!(427.734, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_mebibits_1() {
		let result: f64 = data_storage::kilobits::to_mebibits(77790.0);
		assert_approx_eq!(74.186325, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_mebibits_2() {
		let result: f64 = data_storage::kilobits::to_mebibits(123456.0);
		assert_approx_eq!(117.736816, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobits_to_mebibits_3() {
		let result: f64 = data_storage::kilobits::to_mebibits(23972.0);
		assert_approx_eq!(22.861481, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_bits_1() {
		let result: f64 = data_storage::kilobytes::to_bits(123.456);
		assert_approx_eq!(987648.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_bits_2() {
		let result: f64 = data_storage::kilobytes::to_bits(900.0);
		assert_approx_eq!(7.2e+6, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_bits_3() {
		let result: f64 = data_storage::kilobytes::to_bits(100200.0);
		assert_approx_eq!(801600000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_kilobits_1() {
		let result: f64 = data_storage::kilobytes::to_kilobits(4.0);
		assert_approx_eq!(32.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_kilobits_2() {
		let result: f64 = data_storage::kilobytes::to_kilobits(1.2);
		assert_approx_eq!(9.6, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_kilobits_3() {
		let result: f64 = data_storage::kilobytes::to_kilobits(88.1);
		assert_approx_eq!(704.8, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_megabits_1() {
		let result: f64 = data_storage::kilobytes::to_megabits(88.1);
		assert_approx_eq!(0.7048, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_megabits_2() {
		let result: f64 = data_storage::kilobytes::to_megabits(7.1);
		assert_approx_eq!(0.0568, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_megabits_3() {
		let result: f64 = data_storage::kilobytes::to_megabits(12.8);
		assert_approx_eq!(0.1024, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_gigabits_1() {
		let result: f64 = data_storage::kilobytes::to_gigabits(10080.0);
		assert_approx_eq!(0.08064, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_gigabits_2() {
		let result: f64 = data_storage::kilobytes::to_gigabits(4.5e+9);
		assert_approx_eq!(36000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_gigabits_3() {
		let result: f64 = data_storage::kilobytes::to_gigabits(271279.0);
		assert_approx_eq!(2.170232, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_terabits_1() {
		let result: f64 = data_storage::kilobytes::to_terabits(9009000.0);
		assert_approx_eq!(0.072072, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_terabits_2() {
		let result: f64 = data_storage::kilobytes::to_terabits(7.2e9);
		assert_approx_eq!(57.6, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_terabits_3() {
		let result: f64 = data_storage::kilobytes::to_terabits(100100100900.0);
		assert_approx_eq!(800.8008072, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_megabytes_1() {
		let result: f64 = data_storage::kilobytes::to_megabytes(1009.0);
		assert_approx_eq!(1.009, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_megabytes_2() {
		let result: f64 = data_storage::kilobytes::to_megabytes(8899.0);
		assert_approx_eq!(8.899, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_megabytes_3() {
		let result: f64 = data_storage::kilobytes::to_megabytes(619.0);
		assert_approx_eq!(0.619, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_gigabytes_1() {
		let result: f64 = data_storage::kilobytes::to_gigabytes(900800.0);
		assert_approx_eq!(0.9008, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_gigabytes_2() {
		let result: f64 = data_storage::kilobytes::to_gigabytes(1234567.0);
		assert_approx_eq!(1.234567, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_gigabytes_3() {
		let result: f64 = data_storage::kilobytes::to_gigabytes(7.9e9);
		assert_approx_eq!(7900.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_terabytes_1() {
		let result: f64 = data_storage::kilobytes::to_terabytes(0.9);
		assert_approx_eq!(9e-10, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_terabytes_2() {
		let result: f64 = data_storage::kilobytes::to_terabytes(140000000.0);
		assert_approx_eq!(0.14, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_terabytes_3() {
		let result: f64 = data_storage::kilobytes::to_terabytes(7.0);
		assert_approx_eq!(7e-9, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_kibibits_1() {
		let result: f64 = data_storage::kilobytes::to_kibibits(0.009);
		assert_approx_eq!(0.0703125, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_kibibits_2() {
		let result: f64 = data_storage::kilobytes::to_kibibits(6e+3);
		assert_approx_eq!(46875.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_kibibits_3() {
		let result: f64 = data_storage::kilobytes::to_kibibits(1.23);
		assert_approx_eq!(9.609375, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_mebibits_1() {
		let result: f64 = data_storage::kilobytes::to_mebibits(70.0);
		assert_approx_eq!(0.534058, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_mebibits_2() {
		let result: f64 = data_storage::kilobytes::to_mebibits(9.0);
		assert_approx_eq!(0.0686646, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownkilobytes_to_mebibits_3() {
		let result: f64 = data_storage::kilobytes::to_mebibits(10022.0);
		assert_approx_eq!(76.461792, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_bits_1() {
		let result: f64 = data_storage::mebibits::to_bits(0.9);
		assert_approx_eq!(943718.4, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_bits_2() {
		let result: f64 = data_storage::mebibits::to_bits(0.006);
		assert_approx_eq!(6291.456, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_bits_3() {
		let result: f64 = data_storage::mebibits::to_bits(2.0);
		assert_approx_eq!(2097152.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_kilobits_1() {
		let result: f64 = data_storage::mebibits::to_kilobits(0.8);
		assert_approx_eq!(838.861, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_kilobits_2() {
		let result: f64 = data_storage::mebibits::to_kilobits(2.0);
		assert_approx_eq!(2097.15, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_kilobits_3() {
		let result: f64 = data_storage::mebibits::to_kilobits(0.23);
		assert_approx_eq!(241.1725, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_megabits_1() {
		let result: f64 = data_storage::mebibits::to_megabits(0.9);
		assert_approx_eq!(0.943718, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_megabits_2() {
		let result: f64 = data_storage::mebibits::to_megabits(12.3);
		assert_approx_eq!(12.89748, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_megabits_3() {
		let result: f64 = data_storage::mebibits::to_megabits(8.1);
		assert_approx_eq!(8.49347, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_gigabits_1() {
		let result: f64 = data_storage::mebibits::to_gigabits(12345.0);
		assert_approx_eq!(12.944671, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_gigabits_2() {
		let result: f64 = data_storage::mebibits::to_gigabits(100.0);
		assert_approx_eq!(0.104858, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_gigabits_3() {
		let result: f64 = data_storage::mebibits::to_gigabits(999.9);
		assert_approx_eq!(1.0484711, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_terabits_1() {
		let result: f64 = data_storage::mebibits::to_terabits(100009.0);
		assert_approx_eq!(0.104867037, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_terabits_2() {
		let result: f64 = data_storage::mebibits::to_terabits(9876543.0);
		assert_approx_eq!(10.35630595, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_terabits_3() {
		let result: f64 = data_storage::mebibits::to_terabits(1000900.0);
		assert_approx_eq!(1.049519718, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_kilobytes_1() {
		let result: f64 = data_storage::mebibits::to_kilobytes(4.0);
		assert_approx_eq!(524.288, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_kilobytes_2() {
		let result: f64 = data_storage::mebibits::to_kilobytes(1.45);
		assert_approx_eq!(190.0544, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_kilobytes_3() {
		let result: f64 = data_storage::mebibits::to_kilobytes(88.11);
		assert_approx_eq!(11548.754, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_megabytes_1() {
		let result: f64 = data_storage::mebibits::to_megabytes(109.0);
		assert_approx_eq!(14.2868, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_megabytes_2() {
		let result: f64 = data_storage::mebibits::to_megabytes(55.67);
		assert_approx_eq!(7.2967782, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_megabytes_3() {
		let result: f64 = data_storage::mebibits::to_megabytes(45678.0);
		assert_approx_eq!(5987.1068, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_gigabytes_1() {
		let result: f64 = data_storage::mebibits::to_gigabytes(4000.0);
		assert_approx_eq!(0.524288311, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_gigabytes_2() {
		let result: f64 = data_storage::mebibits::to_gigabytes(90100.0);
		assert_approx_eq!(11.80959421, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_gigabytes_3() {
		let result: f64 = data_storage::mebibits::to_gigabytes(1009.0);
		assert_approx_eq!(0.132251727, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_terabytes_1() {
		let result: f64 = data_storage::mebibits::to_terabytes(1000009.0);
		assert_approx_eq!(0.1310731796, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_terabytes_2() {
		let result: f64 = data_storage::mebibits::to_terabytes(90808080.0);
		assert_approx_eq!(11.902396662, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_terabytes_3() {
		let result: f64 = data_storage::mebibits::to_terabytes(5.2e12);
		assert_approx_eq!(681574.4, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_kibibits_1() {
		let result: f64 = data_storage::mebibits::to_kibibits(5.0);
		assert_approx_eq!(5120.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_kibibits_2() {
		let result: f64 = data_storage::mebibits::to_kibibits(1234.56);
		assert_approx_eq!(1264189.44, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmebibits_to_kibibits_3() {
		let result: f64 = data_storage::mebibits::to_kibibits(505.0);
		assert_approx_eq!(517120.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_bits_1() {
		let result: f64 = data_storage::megabits::to_bits(0.34);
		assert_approx_eq!(340000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_bits_2() {
		let result: f64 = data_storage::megabits::to_bits(9.12);
		assert_approx_eq!(9120000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_bits_3() {
		let result: f64 = data_storage::megabits::to_bits(0.987);
		assert_approx_eq!(987000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_kilobits_1() {
		let result: f64 = data_storage::megabits::to_kilobits(0.77);
		assert_approx_eq!(770.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_kilobits_2() {
		let result: f64 = data_storage::megabits::to_kilobits(5.0);
		assert_approx_eq!(5000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_kilobits_3() {
		let result: f64 = data_storage::megabits::to_kilobits(0.987);
		assert_approx_eq!(987.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_gigabits_1() {
		let result: f64 = data_storage::megabits::to_gigabits(900.0);
		assert_approx_eq!(0.9, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_gigabits_2() {
		let result: f64 = data_storage::megabits::to_gigabits(12345.0);
		assert_approx_eq!(12.345, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_gigabits_3() {
		let result: f64 = data_storage::megabits::to_gigabits(189.1);
		assert_approx_eq!(0.1891, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_terabits_1() {
		let result: f64 = data_storage::megabits::to_terabits(100200300.0);
		assert_approx_eq!(100.2003, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_terabits_2() {
		let result: f64 = data_storage::megabits::to_terabits(99887777.0);
		assert_approx_eq!(99.887777, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_terabits_3() {
		let result: f64 = data_storage::megabits::to_terabits(80009.0);
		assert_approx_eq!(0.080009, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_kilobytes_1() {
		let result: f64 = data_storage::megabits::to_kilobytes(9.0);
		assert_approx_eq!(1125.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_kilobytes_2() {
		let result: f64 = data_storage::megabits::to_kilobytes(1.23);
		assert_approx_eq!(153.75, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_kilobytes_3() {
		let result: f64 = data_storage::megabits::to_kilobytes(98.1);
		assert_approx_eq!(12262.5, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_megabytes_1() {
		let result: f64 = data_storage::megabits::to_megabytes(98.1);
		assert_approx_eq!(12.2625, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_megabytes_2() {
		let result: f64 = data_storage::megabits::to_megabytes(10.9);
		assert_approx_eq!(1.3625, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_megabytes_3() {
		let result: f64 = data_storage::megabits::to_megabytes(888.123);
		assert_approx_eq!(111.015375, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_gigabytes_1() {
		let result: f64 = data_storage::megabits::to_gigabytes(900.0);
		assert_approx_eq!(0.1125, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_gigabytes_2() {
		let result: f64 = data_storage::megabits::to_gigabytes(10123.0);
		assert_approx_eq!(1.265375, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_gigabytes_3() {
		let result: f64 = data_storage::megabits::to_gigabytes(9988.0);
		assert_approx_eq!(1.2485, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_terabytes_1() {
		let result: f64 = data_storage::megabits::to_terabytes(998877.0);
		assert_approx_eq!(0.124859625, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_terabytes_2() {
		let result: f64 = data_storage::megabits::to_terabytes(100200400.0);
		assert_approx_eq!(12.5250375, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_terabytes_3() {
		let result: f64 = data_storage::megabits::to_terabytes(9008877.0);
		assert_approx_eq!(1.126109625, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_kibibits_1() {
		let result: f64 = data_storage::megabits::to_kibibits(12.0);
		assert_approx_eq!(11718.756, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_kibibits_2() {
		let result: f64 = data_storage::megabits::to_kibibits(0.9);
		assert_approx_eq!(878.906, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_kibibits_3() {
		let result: f64 = data_storage::megabits::to_kibibits(1.23);
		assert_approx_eq!(1201.172, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_mebibits_1() {
		let result: f64 = data_storage::megabits::to_mebibits(4.5);
		assert_approx_eq!(4.29153, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_mebibits_2() {
		let result: f64 = data_storage::megabits::to_mebibits(0.8);
		assert_approx_eq!(0.762939, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabits_to_mebibits_3() {
		let result: f64 = data_storage::megabits::to_mebibits(900.0);
		assert_approx_eq!(858.307, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_bits_1() {
		let result: f64 = data_storage::megabytes::to_bits(0.04);
		assert_approx_eq!(320000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_bits_2() {
		let result: f64 = data_storage::megabytes::to_bits(0.0091);
		assert_approx_eq!(72800.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_bits_3() {
		let result: f64 = data_storage::megabytes::to_bits(3e-5);
		assert_approx_eq!(240.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_kilobits_1() {
		let result: f64 = data_storage::megabytes::to_kilobits(6.0);
		assert_approx_eq!(48000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_kilobits_2() {
		let result: f64 = data_storage::megabytes::to_kilobits(0.3);
		assert_approx_eq!(2400.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_kilobits_3() {
		let result: f64 = data_storage::megabytes::to_kilobits(0.009);
		assert_approx_eq!(72.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_megabits_1() {
		let result: f64 = data_storage::megabytes::to_megabits(3.0);
		assert_approx_eq!(24.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_megabits_2() {
		let result: f64 = data_storage::megabytes::to_megabits(0.9);
		assert_approx_eq!(7.2, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_megabits_3() {
		let result: f64 = data_storage::megabytes::to_megabits(13.0);
		assert_approx_eq!(104.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_gigabits_1() {
		let result: f64 = data_storage::megabytes::to_gigabits(13.0);
		assert_approx_eq!(0.104, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_gigabits_2() {
		let result: f64 = data_storage::megabytes::to_gigabits(900.0);
		assert_approx_eq!(7.2, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_gigabits_3() {
		let result: f64 = data_storage::megabytes::to_gigabits(18000.0);
		assert_approx_eq!(144.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_terabits_1() {
		let result: f64 = data_storage::megabytes::to_terabits(18000.0);
		assert_approx_eq!(0.144, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_terabits_2() {
		let result: f64 = data_storage::megabytes::to_terabits(9718290.0);
		assert_approx_eq!(77.74632, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_terabits_3() {
		let result: f64 = data_storage::megabytes::to_terabits(9e12);
		assert_approx_eq!(72000000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_kilobytes_1() {
		let result: f64 = data_storage::megabytes::to_kilobytes(6.0);
		assert_approx_eq!(6000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_kilobytes_2() {
		let result: f64 = data_storage::megabytes::to_kilobytes(0.9);
		assert_approx_eq!(900.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_kilobytes_3() {
		let result: f64 = data_storage::megabytes::to_kilobytes(123.4);
		assert_approx_eq!(123400.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_gigabytes_1() {
		let result: f64 = data_storage::megabytes::to_gigabytes(123.4);
		assert_approx_eq!(0.1234, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_gigabytes_2() {
		let result: f64 = data_storage::megabytes::to_gigabytes(900.0);
		assert_approx_eq!(0.9, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_gigabytes_3() {
		let result: f64 = data_storage::megabytes::to_gigabytes(8e6);
		assert_approx_eq!(8000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_terabytes_1() {
		let result: f64 = data_storage::megabytes::to_terabytes(80000.0);
		assert_approx_eq!(0.08, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_terabytes_2() {
		let result: f64 = data_storage::megabytes::to_terabytes(12345678.0);
		assert_approx_eq!(12.345678, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_terabytes_3() {
		let result: f64 = data_storage::megabytes::to_terabytes(900800.0);
		assert_approx_eq!(0.9008, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_kibibits_1() {
		let result: f64 = data_storage::megabytes::to_kibibits(6.0);
		assert_approx_eq!(46875.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_kibibits_2() {
		let result: f64 = data_storage::megabytes::to_kibibits(0.9);
		assert_approx_eq!(7031.25, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_kibibits_3() {
		let result: f64 = data_storage::megabytes::to_kibibits(0.03);
		assert_approx_eq!(234.375, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_mebibits_1() {
		let result: f64 = data_storage::megabytes::to_mebibits(0.03);
		assert_approx_eq!(0.2288818, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_mebibits_2() {
		let result: f64 = data_storage::megabytes::to_mebibits(4.5);
		assert_approx_eq!(34.3323, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownmegabytes_to_mebibits_3() {
		let result: f64 = data_storage::megabytes::to_mebibits(80.1);
		assert_approx_eq!(611.1145, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_bits_1() {
		let result: f64 = data_storage::terabits::to_bits(0.0007);
		assert_approx_eq!(700000000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_bits_2() {
		let result: f64 = data_storage::terabits::to_bits(1.23e-6);
		assert_approx_eq!(1230000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_bits_3() {
		let result: f64 = data_storage::terabits::to_bits(0.00098);
		assert_approx_eq!(980000000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_kilobits_1() {
		let result: f64 = data_storage::terabits::to_kilobits(0.001);
		assert_approx_eq!(1000000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_kilobits_2() {
		let result: f64 = data_storage::terabits::to_kilobits(6.1e-6);
		assert_approx_eq!(6100.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_kilobits_3() {
		let result: f64 = data_storage::terabits::to_kilobits(0.00009);
		assert_approx_eq!(90000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_megabits_1() {
		let result: f64 = data_storage::terabits::to_megabits(0.09);
		assert_approx_eq!(90000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_megabits_2() {
		let result: f64 = data_storage::terabits::to_megabits(3.5e-4);
		assert_approx_eq!(350.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_megabits_3() {
		let result: f64 = data_storage::terabits::to_megabits(0.0123);
		assert_approx_eq!(12300.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_gigabits_1() {
		let result: f64 = data_storage::terabits::to_gigabits(0.9);
		assert_approx_eq!(900.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_gigabits_2() {
		let result: f64 = data_storage::terabits::to_gigabits(1.45);
		assert_approx_eq!(1450.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_gigabits_3() {
		let result: f64 = data_storage::terabits::to_gigabits(8.19);
		assert_approx_eq!(8190.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_kilobytes_1() {
		let result: f64 = data_storage::terabits::to_kilobytes(0.0009);
		assert_approx_eq!(112500.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_kilobytes_2() {
		let result: f64 = data_storage::terabits::to_kilobytes(3.14e-6);
		assert_approx_eq!(392.5, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_kilobytes_3() {
		let result: f64 = data_storage::terabits::to_kilobytes(0.001);
		assert_approx_eq!(125000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_megabytes_1() {
		let result: f64 = data_storage::terabits::to_megabytes(0.4);
		assert_approx_eq!(50000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_megabytes_2() {
		let result: f64 = data_storage::terabits::to_megabytes(3.9e-3);
		assert_approx_eq!(487.5, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_megabytes_3() {
		let result: f64 = data_storage::terabits::to_megabytes(0.007);
		assert_approx_eq!(875.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_gigabytes_1() {
		let result: f64 = data_storage::terabits::to_gigabytes(0.009);
		assert_approx_eq!(1.125, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_gigabytes_2() {
		let result: f64 = data_storage::terabits::to_gigabytes(0.00123);
		assert_approx_eq!(0.15375, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_gigabytes_3() {
		let result: f64 = data_storage::terabits::to_gigabytes(8.1e-3);
		assert_approx_eq!(1.0125, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_terabytes_1() {
		let result: f64 = data_storage::terabits::to_terabytes(0.3);
		assert_approx_eq!(0.0375, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_terabytes_2() {
		let result: f64 = data_storage::terabits::to_terabytes(14.0);
		assert_approx_eq!(1.75, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_terabytes_3() {
		let result: f64 = data_storage::terabits::to_terabytes(0.8);
		assert_approx_eq!(0.1, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_kibibits_1() {
		let result: f64 = data_storage::terabits::to_kibibits(0.0009);
		assert_approx_eq!(878906.25, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_kibibits_2() {
		let result: f64 = data_storage::terabits::to_kibibits(6.1e-6);
		assert_approx_eq!(5957.031, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_kibibits_3() {
		let result: f64 = data_storage::terabits::to_kibibits(12e-9);
		assert_approx_eq!(11.71875, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_mebibits_1() {
		let result: f64 = data_storage::terabits::to_mebibits(0.9);
		assert_approx_eq!(858306.59999, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_mebibits_2() {
		let result: f64 = data_storage::terabits::to_mebibits(4.6e-3);
		assert_approx_eq!(4386.9, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabits_to_mebibits_3() {
		let result: f64 = data_storage::terabits::to_mebibits(0.00123);
		assert_approx_eq!(1173.0194092, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_bits_1() {
		let result: f64 = data_storage::terabytes::to_bits(0.00008);
		assert_approx_eq!(640000000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_bits_2() {
		let result: f64 = data_storage::terabytes::to_bits(1.2e-12);
		assert_approx_eq!(9.6, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_bits_3() {
		let result: f64 = data_storage::terabytes::to_bits(9.0);
		assert_approx_eq!(7.2e+13, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_kilobits_1() {
		let result: f64 = data_storage::terabytes::to_kilobits(0.009);
		assert_approx_eq!(72000000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_kilobits_2() {
		let result: f64 = data_storage::terabytes::to_kilobits(1.4e-6);
		assert_approx_eq!(11200.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_kilobits_3() {
		let result: f64 = data_storage::terabytes::to_kilobits(6.1e-5);
		assert_approx_eq!(488000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_megabits_1() {
		let result: f64 = data_storage::terabytes::to_megabits(0.005);
		assert_approx_eq!(40000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_megabits_2() {
		let result: f64 = data_storage::terabytes::to_megabits(0.000123);
		assert_approx_eq!(984.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_megabits_3() {
		let result: f64 = data_storage::terabytes::to_megabits(0.00006);
		assert_approx_eq!(480.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_gigabits_1() {
		let result: f64 = data_storage::terabytes::to_gigabits(0.008);
		assert_approx_eq!(64.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_gigabits_2() {
		let result: f64 = data_storage::terabytes::to_gigabits(3e-7);
		assert_approx_eq!(0.0024, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_gigabits_3() {
		let result: f64 = data_storage::terabytes::to_gigabits(0.00023);
		assert_approx_eq!(1.84, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_terabits_1() {
		let result: f64 = data_storage::terabytes::to_terabits(5.0);
		assert_approx_eq!(40.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_terabits_2() {
		let result: f64 = data_storage::terabytes::to_terabits(1.23);
		assert_approx_eq!(9.84, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_terabits_3() {
		let result: f64 = data_storage::terabytes::to_terabits(800.0);
		assert_approx_eq!(6400.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_kilobytes_1() {
		let result: f64 = data_storage::terabytes::to_kilobytes(0.0009);
		assert_approx_eq!(900000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_kilobytes_2() {
		let result: f64 = data_storage::terabytes::to_kilobytes(3.14e-7);
		assert_approx_eq!(314.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_kilobytes_3() {
		let result: f64 = data_storage::terabytes::to_kilobytes(0.00063);
		assert_approx_eq!(630000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_megabytes_1() {
		let result: f64 = data_storage::terabytes::to_megabytes(0.009);
		assert_approx_eq!(9000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_megabytes_2() {
		let result: f64 = data_storage::terabytes::to_megabytes(0.234);
		assert_approx_eq!(234000.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_megabytes_3() {
		let result: f64 = data_storage::terabytes::to_megabytes(2.0);
		assert_approx_eq!(2e+6, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_gigabytes_1() {
		let result: f64 = data_storage::terabytes::to_gigabytes(2.7);
		assert_approx_eq!(2700.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_gigabytes_2() {
		let result: f64 = data_storage::terabytes::to_gigabytes(0.9);
		assert_approx_eq!(900.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_gigabytes_3() {
		let result: f64 = data_storage::terabytes::to_gigabytes(0.0123);
		assert_approx_eq!(12.3, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_kibibits_1() {
		let result: f64 = data_storage::terabytes::to_kibibits(0.0009);
		assert_approx_eq!(7031250.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_kibibits_2() {
		let result: f64 = data_storage::terabytes::to_kibibits(1.23e-5);
		assert_approx_eq!(96093.75, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_kibibits_3() {
		let result: f64 = data_storage::terabytes::to_kibibits(0.0001);
		assert_approx_eq!(781250.0, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_mebibits_1() {
		let result: f64 = data_storage::terabytes::to_mebibits(0.01);
		assert_approx_eq!(76293.95, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_mebibits_2() {
		let result: f64 = data_storage::terabytes::to_mebibits(0.008);
		assert_approx_eq!(61035.156, result, 0.01);
	}

	/// Need to convert to parameterized tests
	#[test]
	fn it_convert_knownterabytes_to_mebibits_3() {
		let result: f64 = data_storage::terabytes::to_mebibits(2.0);
		assert_approx_eq!(15258789.0625, result, 0.01);
	}

}
