use chrono::{DateTime, Utc};
use ic_cdk::api::time;
use ic_cdk::export::candid::{CandidType, Deserialize, Principal};
use ic_cdk::{caller, print};
use std::time::{Duration, SystemTime, UNIX_EPOCH};

#[derive(Clone, PartialEq, Eq, Hash, CandidType, Deserialize)]
pub struct RemoteCallEndpoint {
    pub canister_id: Principal,
    pub method_name: String,
}

#[derive(Clone, CandidType, Deserialize)]
pub struct RemoteCallPayload {
    pub endpoint: RemoteCallEndpoint,
    pub args_raw: Vec<u8>,
    pub cycles: u64,
}

#[inline(always)]
pub fn log(msg: &str) {
    print(format!(
        "{}: [caller: {}]: {}",
        make_time(time()),
        caller(),
        msg
    ))
}

fn make_time(nanos: u64) -> String {
    let d = UNIX_EPOCH + Duration::from_nanos(nanos);
    let datetime = DateTime::<Utc>::from(d);

    datetime.format("%Y-%m-%d %H:%M:%S.%f").to_string()
}

#[inline(always)]
pub fn random_principal_test() -> Principal {
    Principal::from_slice(
        &SystemTime::now()
            .duration_since(UNIX_EPOCH)
            .unwrap()
            .as_nanos()
            .to_be_bytes(),
    )
}
