use ic_cdk::export::candid::{CandidType, Deserialize, Principal};
use ic_cdk::{caller, print};
use ic_event_hub_macros::Event;
use std::time::{SystemTime, UNIX_EPOCH};

#[derive(Event, CandidType, Deserialize)]
pub struct VotingPowerUpdateEvent {
    #[topic]
    pub voter: Principal,
    pub new_voting_power: u64,
}

#[derive(Event, CandidType, Deserialize)]
pub struct TotalVotingPowerUpdateEvent {
    pub new_total_voting_power: u64,
}

#[derive(Clone, PartialEq, Eq, Hash, CandidType, Deserialize)]
pub struct RemoteCallEndpoint {
    pub canister_id: Principal,
    pub method_name: String,
}

#[derive(Clone, CandidType, Deserialize)]
pub struct RemoteCallPayload {
    pub endpoint: RemoteCallEndpoint,
    pub args_raw: Vec<u8>,
    pub cycles: u64,
}

pub fn log(msg: &str) {
    print(format!("[caller: {}]: {}", caller(), msg))
}

pub fn random_principal_test() -> Principal {
    Principal::from_slice(
        &SystemTime::now()
            .duration_since(UNIX_EPOCH)
            .unwrap()
            .as_nanos()
            .to_be_bytes(),
    )
}