//! Implementations of [the disjoint-set forest data structure that supports the union-find
//! algorithm](https://en.wikipedia.org/wiki/Disjoint-set_data_structure).
//!
//! # Background / Context
//!
//! 1. [Wikipedia article: disjoint-set data structure](https://en.wikipedia.org/wiki/Disjoint-set_data_structure)
//!
//! # Getting Started
//!
//! 1. `use union_find::prelude::*;` to import everything necessary
//! 1. see the trait [`UnionFind`](crate::traits::UnionFind) for the core operations of union-find
//! 1. see the struct [`DisjointSets`](crate::disjoint_sets::DisjointSets) for an implementation of
//! [`UnionFind`](crate::traits::UnionFind)

pub mod disjoint_sets;
mod node;
pub mod prelude;
pub mod traits;
